/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.coke_oven;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.metallurgy.coke_oven.CokeOvenBlock;
import com.drmangotea.tfmg.content.machinery.metallurgy.coke_oven.CokeOvenPacket;
import com.drmangotea.tfmg.recipes.CokingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class CokeOvenBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SmartInventory inventory;
    public FluidTank primaryTank;
    public FluidTank secondaryTank;
    protected IFluidHandler primaryFluidCapability;
    protected IFluidHandler secondaryFluidCapability;
    public IItemHandlerModifiable itemCapability;
    int timer = -1;
    public LerpedFloat doorAngle = LerpedFloat.angular();
    public boolean createNextTick;
    public BlockPos controller = this.getBlockPos();
    public int size = 1;
    public boolean forceOpen = false;

    public CokeOvenBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.inventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(64).whenContentsChanged(i -> this.onContentsChanged());
        this.primaryTank = new SmartFluidTank(8000, this::onFluidChanged);
        this.secondaryTank = new SmartFluidTank(8000, this::onFluidChanged);
        this.itemCapability = this.inventory;
        this.primaryFluidCapability = this.primaryTank;
        this.secondaryFluidCapability = this.secondaryTank;
        this.createNextTick = true;
    }

    public void onContentsChanged() {
        if (!this.inventory.isEmpty() && this.timer == -1) {
            this.executeRecipe();
        }
        if (this.inventory.isEmpty()) {
            this.timer = -1;
        }
    }

    public void executeRecipe() {
        Optional optional = TFMGRecipeTypes.COKING.find(new RecipeWrapper((IItemHandler)this.inventory), this.level);
        if (optional.isEmpty()) {
            return;
        }
        CokingRecipe recipe = (CokingRecipe)optional.get().value();
        if (((Ingredient)recipe.getIngredients().get(0)).test(this.inventory.getItem(0))) {
            this.timer = recipe.getProcessingDuration() / Math.max(this.size / 2, 1);
        }
    }

    private void onFluidChanged(FluidStack stack) {
        if (!this.hasLevel()) {
            return;
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    public void tick() {
        super.tick();
        this.tickRecipe();
        if (this.level.isClientSide) {
            this.doorAngle.chase(this.timer > 0 && this.timer < 50 || this.forceOpen ? 90.0 : 0.0, (double)0.1f, LerpedFloat.Chaser.EXP);
            this.doorAngle.tickChaser();
            if (!this.forceOpen) {
                this.manageDoors(this.timer > 0 && this.timer < 50);
            }
        }
        if (this.createNextTick) {
            this.createMultiblock();
            this.createNextTick = false;
        }
    }

    public void tickRecipe() {
        if (this.inventory.isEmpty() || this.timer == -1) {
            return;
        }
        Optional optional = TFMGRecipeTypes.COKING.find(new RecipeWrapper((IItemHandler)this.inventory), this.level);
        if (optional.isEmpty()) {
            this.timer = -1;
            return;
        }
        CokingRecipe recipe = (CokingRecipe)optional.get().value();
        if (this.timer == 0) {
            this.timer = -1;
            this.inventory.getItem(0).shrink(((Ingredient)recipe.getIngredients().get(0)).getItems()[0].getCount());
            Direction direction = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
            Vec3 dropVec = VecHelper.getCenterOf((Vec3i)this.worldPosition.relative(direction)).add(0.0, 0.4, 0.0);
            ItemEntity dropped = new ItemEntity(this.level, dropVec.x, dropVec.y, dropVec.z, recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy());
            dropped.setDefaultPickUpDelay();
            dropped.setDeltaMovement(direction.getAxis() == Direction.Axis.X ? (direction == Direction.WEST ? (double)-0.01f : (double)0.01f) : 0.0, (double)0.05f, direction.getAxis() == Direction.Axis.Z ? (direction == Direction.NORTH ? (double)-0.01f : (double)0.01f) : 0.0);
            this.level.addFreshEntity((Entity)dropped);
            if (!this.level.isClientSide) {
                this.setChanged();
                this.sendData();
            }
            this.onContentsChanged();
        }
        if (this.timer > 0 && this.primaryTank.getSpace() != 0 && this.secondaryTank.getSpace() != 0) {
            this.primaryTank.fill(recipe.getPrimaryResult(), IFluidHandler.FluidAction.EXECUTE);
            this.secondaryTank.fill(recipe.getSecondaryResult(), IFluidHandler.FluidAction.EXECUTE);
            --this.timer;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.onContentsChanged();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TFMGTexts.header("coke_oven").style(ChatFormatting.GRAY).forGoggles(tooltip);
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof CokeOvenBlockEntity) {
            CokeOvenBlockEntity controller = (CokeOvenBlockEntity)blockEntity;
            if (controller.timer > 0) {
                TFMGTexts.progress((double)controller.timer / 20.0).style(ChatFormatting.GOLD).forGoggles(tooltip);
            }
        }
        CokeOvenBlockEntity.createFluidTooltip(this, tooltip);
        TFMGUtils.createItemTooltip((BlockEntity)this, tooltip);
        return true;
    }

    public static boolean createFluidTooltip(CokeOvenBlockEntity be, List<Component> tooltip) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        BlockEntity blockEntity = be.level.getBlockEntity(be.controller);
        if (blockEntity instanceof CokeOvenBlockEntity) {
            CokeOvenBlockEntity controller = (CokeOvenBlockEntity)blockEntity;
            CombinedTankWrapper tank = new CombinedTankWrapper(new IFluidHandler[]{controller.primaryTank, controller.secondaryTank});
            if (tank.getTanks() == 0) {
                return false;
            }
            TFMGLang.translate("goggles.fluid_storage", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            boolean isEmpty = true;
            for (int i = 0; i < tank.getTanks(); ++i) {
                FluidStack fluidStack = tank.getFluidInTank(i);
                if (fluidStack.isEmpty()) continue;
                TFMGLang.fluidName(fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
                TFMGLang.builder().add(TFMGLang.number(fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(TFMGLang.number(tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
                isEmpty = false;
            }
            if (tank.getTanks() > 1) {
                if (isEmpty) {
                    tooltip.remove(tooltip.size() - 1);
                }
                return true;
            }
            if (!isEmpty) {
                return true;
            }
            CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(TFMGLang.number(tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        }
        return true;
    }

    public void manageDoors(boolean open) {
        for (int i = 0; i < this.size; ++i) {
            BlockPos pos = this.getBlockPos().above(i);
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof CokeOvenBlockEntity)) continue;
            CokeOvenBlockEntity be = (CokeOvenBlockEntity)blockEntity;
            if (pos == this.getBlockPos()) continue;
            be.forceOpen = open;
        }
    }

    public boolean isController() {
        return this.controller == this.getBlockPos();
    }

    public void createMultiblock() {
        CokeOvenBlockEntity be;
        BlockEntity blockEntity;
        if (this.level == null) {
            return;
        }
        int maxSize = (Integer)TFMGConfigs.common().machines.cokeOvenMaxSize.get();
        Direction facing = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        if (this.level.getBlockState(this.getBlockPos().relative(facing)).is((Block)TFMGBlocks.COKE_OVEN.get()) || this.level.getBlockState(this.getBlockPos().below()).is((Block)TFMGBlocks.COKE_OVEN.get())) {
            return;
        }
        int size = 1;
        for (int i = 1; i <= maxSize; ++i) {
            boolean cantBuildMultiblock = false;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getBlockPos(), (BlockPos)this.getBlockPos().above(i).relative(facing.getOpposite(), i))) {
                if (!this.level.getBlockState(pos).is((Block)TFMGBlocks.COKE_OVEN.get())) {
                    cantBuildMultiblock = true;
                    continue;
                }
                if (!this.level.getBlockState(pos).is((Block)TFMGBlocks.COKE_OVEN.get()) || this.level.getBlockState(pos).getValue((Property)HorizontalDirectionalBlock.FACING) == facing) continue;
                cantBuildMultiblock = true;
            }
            if (cantBuildMultiblock) break;
            ++size;
        }
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getBlockPos(), (BlockPos)this.getBlockPos().above(size - 1).relative(facing.getOpposite(), size - 1))) {
            blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof CokeOvenBlockEntity)) continue;
            be = (CokeOvenBlockEntity)blockEntity;
            if (this.level.getBlockState(this.getBlockPos().relative(facing)).is((Block)TFMGBlocks.COKE_OVEN.get()) || this.level.getBlockState(this.getBlockPos().below()).is((Block)TFMGBlocks.COKE_OVEN.get())) continue;
            be.controller = this.getBlockPos();
            be.refreshCapability();
        }
        if (!this.level.getBlockState(this.getBlockPos().relative(facing)).is((Block)TFMGBlocks.COKE_OVEN.get()) && !this.level.getBlockState(this.getBlockPos().below()).is((Block)TFMGBlocks.COKE_OVEN.get())) {
            this.setBlockStates(size);
        }
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getBlockPos(), (BlockPos)this.getBlockPos().above(this.size - 1).relative(facing.getOpposite(), this.size - 1))) {
            blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof CokeOvenBlockEntity)) continue;
            be = (CokeOvenBlockEntity)blockEntity;
            if (Math.abs(this.getBlockPos().getX() - be.getBlockPos().getX()) < size && Math.abs(this.getBlockPos().getY() - be.getBlockPos().getY()) < size && Math.abs(this.getBlockPos().getZ() - be.getBlockPos().getZ()) < size || be.controller != this.getBlockPos() && be.controller == be.getBlockPos()) continue;
            be.controller = be.getBlockPos();
            be.refreshCapability();
            be.forceOpen = false;
            be.doorAngle.setValue(0.0);
            this.level.setBlock(be.getBlockPos(), (BlockState)this.getBlockState().setValue(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.CASUAL)), 2);
        }
        this.size = size;
    }

    public void setBlockStates(int size) {
        if (size > 1) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.BOTTOM_ON)), 2);
            this.level.setBlock(this.getBlockPos().above(size - 1), (BlockState)this.getBlockState().setValue(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.TOP_ON)), 2);
        } else {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.CASUAL)), 2);
        }
        for (int i = 0; i < size; ++i) {
            BlockPos pos = this.getBlockPos().above(i);
            if (i <= 0 || i == size - 1) continue;
            this.level.setBlock(pos, (BlockState)this.getBlockState().setValue(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.MIDDLE_ON)), 2);
        }
    }

    public void onPlaced() {
        this.createNextTick = true;
        this.updateOvenBlocks();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new CokeOvenPacket(this.getBlockPos()));
        }
    }

    public void remove() {
        super.remove();
        this.updateOvenBlocks();
    }

    public void destroy() {
        super.destroy();
        if (this.isController()) {
            ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
        }
    }

    public void updateOvenBlocks() {
        int maxSize = (Integer)TFMGConfigs.common().machines.cokeOvenMaxSize.get();
        Direction facing = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getBlockPos(), (BlockPos)this.getBlockPos().below(maxSize).relative(facing, maxSize))) {
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof CokeOvenBlockEntity)) continue;
            CokeOvenBlockEntity be = (CokeOvenBlockEntity)blockEntity;
            be.createMultiblock();
        }
    }

    private void refreshCapability() {
        CokeOvenBlockEntity be;
        IFluidHandler oldPrimaryFluidCap = this.primaryFluidCapability;
        IFluidHandler oldSecondaryFluidCap = this.secondaryFluidCapability;
        IItemHandlerModifiable oldItemCap = this.itemCapability;
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof CokeOvenBlockEntity) {
            CokeOvenBlockEntity be1;
            be = be1 = (CokeOvenBlockEntity)blockEntity;
        } else {
            this.controller = this.getBlockPos();
            be = (CokeOvenBlockEntity)this.level.getBlockEntity(this.getBlockPos());
        }
        this.primaryFluidCapability = be.primaryTank;
        this.secondaryFluidCapability = be.secondaryTank;
        this.itemCapability = be.inventory;
        this.invalidateCapabilities();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.COKE_OVEN.get(), (be, context) -> context == Direction.UP ? be.secondaryFluidCapability : be.primaryFluidCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.COKE_OVEN.get(), (be, context) -> be.itemCapability);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("Timer", this.timer);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.put("PrimaryTankContent", (Tag)this.primaryTank.writeToNBT(registries, new CompoundTag()));
        compound.put("SecondaryTankContent", (Tag)this.secondaryTank.writeToNBT(registries, new CompoundTag()));
        compound.putLong("Controller", this.controller.asLong());
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.timer = compound.getInt("Timer");
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.primaryTank.readFromNBT(registries, compound.getCompound("PrimaryTankContent"));
        this.secondaryTank.readFromNBT(registries, compound.getCompound("SecondaryTankContent"));
        this.controller = BlockPos.of((long)compound.getLong("Controller"));
    }
}

