/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.quad_potato_cannon;

import com.drmangotea.tfmg.TFMGClient;
import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.content.items.weapons.quad_potato_cannon.QuadPotatoCannonItemRenderer;
import com.drmangotea.tfmg.content.items.weapons.quad_potato_cannon.QuadPotatoCannonPacket;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.api.equipment.potatoCannon.PotatoCannonProjectileType;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.potatoCannon.PotatoCannonItem;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.GlobalRegistryAccess;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class QuadPotatoCannonItem
extends ProjectileWeaponItem
implements CustomArmPoseItem {
    public static final int MAX_DAMAGE = 100;

    public QuadPotatoCannonItem(Item.Properties properties) {
        super(properties.durability(100));
    }

    @Nullable
    public static PotatoCannonItem.Ammo getAmmo(Player player, ItemStack heldStack) {
        ItemStack ammoStack = player.getProjectile(heldStack);
        if (ammoStack.isEmpty()) {
            return null;
        }
        Optional optionalType = PotatoCannonProjectileType.getTypeForItem((RegistryAccess)player.level().registryAccess(), (Item)ammoStack.getItem());
        if (optionalType.isEmpty()) {
            return null;
        }
        return new PotatoCannonItem.Ammo(ammoStack, (PotatoCannonProjectileType)((Holder.Reference)optionalType.get()).value());
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (ShootableGadgetItemMethods.shouldSwap((Player)player, (ItemStack)heldStack, (InteractionHand)hand, s -> s.getItem() instanceof QuadPotatoCannonItem)) {
            return InteractionResultHolder.fail((Object)heldStack);
        }
        PotatoCannonItem.Ammo ammo = QuadPotatoCannonItem.getAmmo(player, heldStack);
        if (ammo == null) {
            return InteractionResultHolder.pass((Object)heldStack);
        }
        ItemStack ammoStack = ammo.stack();
        PotatoCannonProjectileType projectileType = ammo.type();
        if (level.isClientSide) {
            TFMGClient.QUAD_POTATO_CANNON_RENDER_HANDLER.dontAnimateItem(hand);
            return InteractionResultHolder.success((Object)heldStack);
        }
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (hand == InteractionHand.MAIN_HAND ? 1 : 0) != 0, (Vec3)new Vec3(0.75, (double)-0.15f, 1.5));
        Vec3 correction = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (hand == InteractionHand.MAIN_HAND ? 1 : 0) != 0, (Vec3)new Vec3((double)-0.05f, 0.0, 0.0)).subtract(player.position().add(0.0, (double)player.getEyeHeight(), 0.0));
        Vec3 lookVec = player.getLookAngle();
        Vec3 motion = lookVec.add(correction).normalize().scale(2.0).scale((double)projectileType.velocityMultiplier());
        float soundPitch = projectileType.soundPitch() + (level.getRandom().nextFloat() - 0.5f) / 4.0f;
        boolean spray = projectileType.split() * 4 > 1;
        Vec3 sprayBase = VecHelper.rotate((Vec3)new Vec3(0.0, 0.1, 0.0), (double)(360.0f * level.getRandom().nextFloat()), (Direction.Axis)Direction.Axis.Z);
        float sprayChange = 360.0f / (float)projectileType.split() * 4.0f;
        ItemStack ammoStackCopy = ammoStack.copy();
        for (int i = 0; i < projectileType.split() * 4; ++i) {
            PotatoProjectileEntity projectile = (PotatoProjectileEntity)AllEntityTypes.POTATO_PROJECTILE.create(level);
            projectile.setItem(ammoStackCopy);
            projectile.setEnchantmentEffectsFromCannon(heldStack);
            Vec3 splitMotion = motion;
            if (spray) {
                float imperfection = 40.0f * (level.getRandom().nextFloat() - 0.5f);
                Vec3 sprayOffset = VecHelper.rotate((Vec3)sprayBase, (double)((float)i * sprayChange + imperfection), (Direction.Axis)Direction.Axis.Z);
                splitMotion = splitMotion.add(VecHelper.lookAt((Vec3)sprayOffset, (Vec3)motion));
            }
            projectile.setPos(barrelPos.x, barrelPos.y, barrelPos.z);
            projectile.setDeltaMovement(splitMotion);
            projectile.setOwner((Entity)player);
            level.addFreshEntity((Entity)projectile);
        }
        if (!player.isCreative()) {
            ammoStack.shrink(1);
            if (ammoStack.isEmpty()) {
                player.getInventory().removeItem(ammoStack);
            }
        }
        if (!BacktankUtil.canAbsorbDamage((LivingEntity)player, (int)QuadPotatoCannonItem.maxUses())) {
            heldStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        ShootableGadgetItemMethods.applyCooldown((Player)player, (ItemStack)heldStack, (InteractionHand)hand, s -> s.getItem() instanceof QuadPotatoCannonItem, (int)projectileType.reloadTicks());
        ShootableGadgetItemMethods.sendPackets((Player)player, b -> new QuadPotatoCannonPacket(barrelPos, lookVec.normalize(), ammoStack, hand, soundPitch, (boolean)b));
        return InteractionResultHolder.success((Object)heldStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            super.appendHoverText(stack, context, tooltip, flag);
            return;
        }
        PotatoCannonItem.Ammo ammo = QuadPotatoCannonItem.getAmmo((Player)player, stack);
        if (ammo == null) {
            super.appendHoverText(stack, context, tooltip, flag);
            return;
        }
        HolderLookup.Provider registries = context.registries();
        if (registries == null) {
            return;
        }
        ItemStack ammoStack = ammo.stack();
        PotatoCannonProjectileType type = ammo.type();
        HolderLookup.RegistryLookup lookup = registries.lookupOrThrow(Registries.ENCHANTMENT);
        int power = stack.getEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.POWER));
        int punch = stack.getEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.PUNCH));
        float additionalDamageMult = 1.0f + (float)power * 0.2f;
        float additionalKnockback = (float)punch * 0.5f;
        String _attack = "potato_cannon.ammo.attack_damage";
        String _reload = "potato_cannon.ammo.reload_ticks";
        String _knockback = "potato_cannon.ammo.knockback";
        tooltip.add(CommonComponents.EMPTY);
        tooltip.add((Component)Component.translatable((String)ammoStack.getDescriptionId()).append((Component)Component.literal((String)":")).withStyle(ChatFormatting.GRAY));
        MutableComponent spacing = CommonComponents.space();
        ChatFormatting green = ChatFormatting.GREEN;
        ChatFormatting darkGreen = ChatFormatting.DARK_GREEN;
        float damageF = (float)type.damage() * additionalDamageMult;
        MutableComponent damage = Component.literal((String)(damageF == (float)Mth.floor((float)damageF) ? "" + Mth.floor((float)damageF) : "" + damageF));
        MutableComponent reloadTicks = Component.literal((String)("" + type.reloadTicks()));
        MutableComponent knockback = Component.literal((String)("" + (type.knockback() + additionalKnockback)));
        damage = damage.withStyle(additionalDamageMult > 1.0f ? green : darkGreen);
        knockback = knockback.withStyle(additionalKnockback > 0.0f ? green : darkGreen);
        reloadTicks = reloadTicks.withStyle(darkGreen);
        tooltip.add((Component)spacing.plainCopy().append((Component)TFMGLang.translateDirect(_attack, damage).withStyle(darkGreen)));
        tooltip.add((Component)spacing.plainCopy().append((Component)TFMGLang.translateDirect(_reload, reloadTicks).withStyle(darkGreen)));
        tooltip.add((Component)spacing.plainCopy().append((Component)TFMGLang.translateDirect(_knockback, knockback).withStyle(darkGreen)));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> PotatoCannonProjectileType.getTypeForItem((RegistryAccess)GlobalRegistryAccess.getOrThrow(), (Item)stack.getItem()).isPresent();
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    protected void shootProjectile(LivingEntity livingEntity, Projectile projectile, int i, float v, float v1, float v2, @Nullable LivingEntity livingEntity1) {
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.POWER)) {
            return true;
        }
        if (enchantment.is(Enchantments.PUNCH)) {
            return true;
        }
        if (enchantment.is(Enchantments.FLAME)) {
            return true;
        }
        if (enchantment.is(Enchantments.LOOTING)) {
            return true;
        }
        if (enchantment.is(AllEnchantments.POTATO_RECOVERY)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)QuadPotatoCannonItem.maxUses());
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)QuadPotatoCannonItem.maxUses());
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)QuadPotatoCannonItem.maxUses());
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxPotatoCannonShots.get();
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.swinging) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new QuadPotatoCannonItemRenderer()));
    }

    public record Ammo(ItemStack stack, PotatoCannonProjectileType type) {
    }
}

