/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.flamethrover;

import com.drmangotea.tfmg.TFMGRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.fluid.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;

public record FlamethrowerFuelType(HolderSet<Fluid> fluids, int spread, float speed, int amount, boolean isCold, boolean hellfire, int color) {
    public static final Codec<FlamethrowerFuelType> CODEC = RecordCodecBuilder.create(i -> i.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID).fieldOf("fluids").forGetter(FlamethrowerFuelType::fluids), (App)Codec.INT.optionalFieldOf("spread", (Object)15).forGetter(FlamethrowerFuelType::spread), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(FlamethrowerFuelType::speed), (App)Codec.INT.optionalFieldOf("amount", (Object)4).forGetter(FlamethrowerFuelType::amount), (App)Codec.BOOL.optionalFieldOf("is_cold", (Object)false).forGetter(FlamethrowerFuelType::isCold), (App)Codec.BOOL.optionalFieldOf("hellfire", (Object)false).forGetter(FlamethrowerFuelType::hellfire), (App)Codec.INT.optionalFieldOf("color", (Object)12888694).forGetter(FlamethrowerFuelType::color)).apply((Applicative)i, FlamethrowerFuelType::new));

    public static Optional<Holder.Reference<FlamethrowerFuelType>> getTypeForFluid(RegistryAccess registryAccess, Fluid fluid) {
        return registryAccess.lookupOrThrow(TFMGRegistries.FLAMETHROWER_FUEL_TYPE).listElements().filter(ref -> ((FlamethrowerFuelType)ref.value()).fluids.contains((Holder)fluid.builtInRegistryHolder())).findFirst();
    }

    public static class Builder {
        private final List<Holder<Fluid>> fluids = new ArrayList<Holder<Fluid>>();
        private int spread = 15;
        private float speed = 1.0f;
        private int amount = 4;
        private boolean isCold = false;
        private boolean hellfire = false;
        private int color = 12888694;

        public Builder spread(int spread) {
            this.spread = spread;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder isCold(boolean isCold) {
            this.isCold = isCold;
            return this;
        }

        public Builder hellfire(boolean hellfire) {
            this.hellfire = hellfire;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder addFluids(Fluid ... fluids) {
            for (Fluid fluid : fluids) {
                this.fluids.add((Holder<Fluid>)FluidHelper.convertToStill((Fluid)fluid).builtInRegistryHolder());
            }
            return this;
        }

        public FlamethrowerFuelType build() {
            return new FlamethrowerFuelType((HolderSet<Fluid>)HolderSet.direct(this.fluids), this.spread, this.speed, this.amount, this.isCold, this.hellfire, this.color);
        }
    }
}

