/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.base;

import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.KineticElectricBlockEntity;
import com.drmangotea.tfmg.content.engines.base.EngineFluidTank;
import com.drmangotea.tfmg.content.engines.fuels.BaseFuelTypes;
import com.drmangotea.tfmg.content.engines.fuels.EngineFuelTypeManager;
import com.drmangotea.tfmg.content.engines.fuels.FuelType;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class AbstractEngineBlockEntity
extends KineticElectricBlockEntity {
    public EngineFluidTank fuelTank;
    public EngineFluidTank exhaustTank;
    public IFluidHandler fluidCapability;
    public float rpm = 0.0f;
    public float fuelInjectionRate = 0.0f;
    public boolean reverse = false;
    public int highestSignal;
    public int signal;
    public BlockPos engineController;
    public float torque = 0.0f;
    public boolean signalChanged;
    public int fuelConsumptionTimer = 0;

    public AbstractEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
        this.fuelTank = new EngineFluidTank(4000, false, true, f -> this.tankUpdated((FluidStack)f, true), TFMGTags.TFMGFluidTags.AIR.tag);
        this.exhaustTank = new EngineFluidTank(8000, true, false, f -> this.tankUpdated((FluidStack)f, false));
        this.fluidCapability = new CombinedTankWrapper(new IFluidHandler[]{this.fuelTank, this.exhaustTank});
        this.refreshCapability();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.REGULAR_ENGINE.get(), (be, context) -> be.fluidCapability);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.TURBINE_ENGINE.get(), (be, context) -> be.fluidCapability);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.RADIAL_ENGINE.get(), (be, context) -> be.fluidCapability);
    }

    @Override
    public void tick() {
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged();
        }
        super.tick();
    }

    public void tankUpdated(FluidStack stack, boolean fuelTank) {
        if (fuelTank && stack.isEmpty()) {
            this.fuelInjectionRate = 0.0f;
            this.updateRotation();
        }
        this.sendData();
        this.setChanged();
    }

    public boolean hasEngineController() {
        return this.engineController != null;
    }

    @Override
    public void updateNetwork() {
        super.updateNetwork();
    }

    protected void analogSignalChanged() {
        int newSignal;
        if (this.hasEngineController()) {
            this.fuelInjectionRate = (float)this.highestSignal / 15.0f;
            return;
        }
        this.signal = newSignal = this.level.getBestNeighborSignal(this.getBlockPos());
        this.highestSignal = newSignal = Math.max(this.level.getBestNeighborSignal(this.getBlockPos()), newSignal);
        this.fuelInjectionRate = (float)this.highestSignal / 15.0f;
        this.updateRotation();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
        this.manageFuelAndExhaust();
    }

    public void manageFuelAndExhaust() {
        this.exhaustTank.forceFill(new FluidStack((Fluid)TFMGFluids.CARBON_DIOXIDE.get(), Math.min(300, this.getFuelConsumption())), IFluidHandler.FluidAction.EXECUTE);
        if (this.fuelConsumptionTimer <= 2) {
            ++this.fuelConsumptionTimer;
        } else {
            this.fuelConsumptionTimer = 0;
            this.fuelTank.forceDrain(this.getFuelConsumption(), IFluidHandler.FluidAction.EXECUTE);
            if (this.fuelTank.isEmpty()) {
                this.updateRotation();
            }
        }
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    public float getSpeedEfficiency() {
        if (this.rpm >= 6000.0f) {
            return 1.0f;
        }
        return 1.0f / (0.08f * (this.rpm / 1000.0f) + 0.5f);
    }

    public abstract List<TagKey<Fluid>> getSupportedFuels();

    public void onUpdated() {
    }

    @Override
    public boolean canWork() {
        if (this.fuelTank.isEmpty()) {
            return false;
        }
        return this.exhaustTank.getSpace() != 0;
    }

    public void updateRotation() {
    }

    public abstract float efficiencyModifier();

    public abstract float speedModifier();

    public abstract float torqueModifier();

    public abstract String engineId();

    public FuelType getFuelType() {
        AtomicReference<FuelType> matchingType = new AtomicReference<FuelType>(BaseFuelTypes.FALLBACK);
        EngineFuelTypeManager.GLOBAL_TYPE_MAP.forEach((r, t) -> {
            TagKey<Fluid> fluidTag = t.getFluid();
            FluidStack fluid = this.fuelTank.getFluid();
            if (fluid.getFluid().is(fluidTag)) {
                matchingType.set((FuelType)t);
            }
        });
        return matchingType.get();
    }

    public void refreshCapability() {
        IFluidHandler oldCap = this.fluidCapability;
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    public IFluidHandler handlerForCapability() {
        return new CombinedTankWrapper(new IFluidHandler[]{this.fuelTank, this.exhaustTank});
    }

    public int getMaxLength() {
        return (Integer)TFMGConfigs.common().machines.engineMaxLength.get();
    }

    public void changeDirection() {
        this.playInsertionSound();
        this.reverse = !this.reverse;
        this.updateRotation();
    }

    public void dropItem(ItemStack stack) {
        Vec3 dropVec = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(0.0, (double)0.3f, 0.0);
        ItemEntity dropped = new ItemEntity(this.level, dropVec.x, dropVec.y, dropVec.z, stack);
        dropped.setDefaultPickUpDelay();
        dropped.setDeltaMovement(0.0, (double)0.15f, 0.0);
        this.level.addFreshEntity((Entity)dropped);
    }

    public void playInsertionSound() {
        this.level.playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.4f, 0.5f);
    }

    public void playRemovalSound() {
        this.level.playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.4f, 0.5f);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.reverse = compound.getBoolean("Reverse");
        this.signal = compound.getInt("Signal") + 1;
        if (this.hasEngineController()) {
            this.engineController = BlockPos.of((long)compound.getLong("EngineController"));
        }
        this.fuelInjectionRate = compound.getFloat("RPM");
        this.fuelTank.readFromNBT(registries, compound.getCompound("FuelTank"));
        this.exhaustTank.readFromNBT(registries, compound.getCompound("ExhaustTank"));
        this.highestSignal = compound.getInt("HighestSignal");
        this.updateRotation();
        this.updateGeneratedRotation();
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putBoolean("Reverse", this.reverse);
        compound.putInt("Signal", this.signal);
        if (this.hasEngineController()) {
            compound.putLong("EngineController", this.engineController.asLong());
        }
        compound.putFloat("RPM", this.fuelInjectionRate);
        compound.put("FuelTank", (Tag)this.fuelTank.writeToNBT(registries, new CompoundTag()));
        compound.put("ExhaustTank", (Tag)this.exhaustTank.writeToNBT(registries, new CompoundTag()));
        compound.putInt("HighestSignal", this.highestSignal);
    }

    public abstract int getFuelConsumption();

    @Override
    public void onPlaced() {
        super.onPlaced();
    }

    public void neighbourChanged() {
        if (!this.hasLevel()) {
            return;
        }
        int power = this.level.getBestNeighborSignal(this.getBlockPos());
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }
}

