/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.blacklist;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.blacklist.Blacklist;
import com.bawnorton.neruina.util.ErroredType;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.Nullable;

public final class BlacklistHandler {
    private final Map<ResourceLocation, Blacklist> blacklists = new HashMap<ResourceLocation, Blacklist>();

    public void init(MinecraftServer server) {
        Map blacklistFiles = server.getResourceManager().listResources("neruina", resource -> resource.getPath().equals("neruina/blacklist.json"));
        if (blacklistFiles.isEmpty()) {
            Neruina.LOGGER.info("No blacklist files found, skipping blacklist loading");
            return;
        }
        for (Map.Entry entry : blacklistFiles.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            Resource resource2 = (Resource)entry.getValue();
            try (JsonReader reader = new JsonReader((Reader)resource2.openAsReader());){
                Blacklist blacklist = Blacklist.fromJson(reader);
                if (blacklist != null) {
                    Neruina.LOGGER.info("Blacklist loaded for namespace: \"{}\"", (Object)id.getNamespace());
                    this.blacklists.put(id, blacklist);
                    continue;
                }
                Neruina.LOGGER.warn("Invalid blacklist found: {}, ignoring", (Object)id);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nullable
    public ResourceLocation getBlacklistFor(ErroredType type, ResourceLocation id) {
        for (Map.Entry<ResourceLocation, Blacklist> entry : this.blacklists.entrySet()) {
            ResourceLocation blacklistId = entry.getKey();
            Blacklist blacklist = entry.getValue();
            if (!blacklist.isBlacklisted(type, id)) continue;
            return blacklistId;
        }
        return null;
    }
}

