/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina;

import com.bawnorton.neruina.platform.ModLoader;
import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.util.annotation.ConditionalMixin;
import com.bawnorton.neruina.util.annotation.DevOnly;
import com.bawnorton.neruina.util.annotation.ModLoaderMixin;
import com.bawnorton.neruina.util.annotation.Version;
import com.bawnorton.neruina.version.ComparableVersion;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class NeruinaMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"NeruinaMixinPlugin");

    private static boolean anyModsLoaded(List<String> modids) {
        for (String modid : modids) {
            if (!Platform.isModLoaded(modid)) continue;
            return true;
        }
        return false;
    }

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetName, String className) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)className).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            boolean shouldApply = true;
            for (AnnotationNode node : annotationNodes) {
                if (node.desc.equals(Type.getDescriptor(ConditionalMixin.class))) {
                    List modids = (List)Annotations.getValue((AnnotationNode)node, (String)"modids");
                    boolean applyIfPresent = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"applyIfPresent", (Object)Boolean.TRUE);
                    if (NeruinaMixinPlugin.anyModsLoaded(modids)) {
                        LOGGER.debug("%s is %sbeing applied because %s are loaded".formatted(className, applyIfPresent ? "" : "not ", modids));
                        shouldApply = applyIfPresent;
                    } else {
                        LOGGER.debug("%s is %sbeing applied because %s are not loaded".formatted(className, !applyIfPresent ? "" : "not ", modids));
                        shouldApply = !applyIfPresent;
                    }
                } else if (node.desc.equals(Type.getDescriptor(ModLoaderMixin.class))) {
                    List modLoaders = Annotations.getValue((AnnotationNode)node, (String)"value", (boolean)true, ModLoader.class);
                    shouldApply = modLoaders.contains((Object)Platform.getModLoader());
                    AnnotationNode versionNode = (AnnotationNode)Annotations.getValue((AnnotationNode)node, (String)"version", Version.class);
                    if (versionNode != null) {
                        String currentVersion = Platform.getVersion();
                        ComparableVersion comparableVersion = new ComparableVersion(currentVersion);
                        String min = (String)Annotations.getValue((AnnotationNode)versionNode, (String)"min", (Object)"");
                        String max = (String)Annotations.getValue((AnnotationNode)versionNode, (String)"max", (Object)"");
                        shouldApply &= this.evaluateVersion(className, min, max, currentVersion, comparableVersion);
                    } else {
                        LOGGER.debug("%s is %sbeing applied because we are using %s".formatted(new Object[]{className, shouldApply ? "" : "not ", Platform.getModLoader()}));
                    }
                } else if (node.desc.equals(Type.getDescriptor(DevOnly.class))) {
                    shouldApply = Platform.isDev();
                }
                if (shouldApply) continue;
                break;
            }
            return shouldApply;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean evaluateVersion(String className, String min, String max, String currentVersion, ComparableVersion comparableVersion) {
        boolean shouldApply = true;
        if (!min.isBlank()) {
            shouldApply &= comparableVersion.compareTo(new ComparableVersion(min)) >= 0;
        }
        if (!max.isBlank()) {
            shouldApply &= comparableVersion.compareTo(new ComparableVersion(max)) <= 0;
        }
        LOGGER.debug("%s is %sbeing applied because we are using %s %s".formatted(new Object[]{className, shouldApply ? "" : "not ", Platform.getModLoader(), currentVersion}));
        return shouldApply;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

