/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.recipe.CustomShapedRecipe;
import dan200.computercraft.shared.recipe.ShapedRecipeSpec;
import dan200.computercraft.shared.recipe.function.RecipeFunction;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class TransformShapedRecipe
extends CustomShapedRecipe {
    public static final MapCodec<TransformShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapedRecipeSpec.CODEC.forGetter(CustomShapedRecipe::toSpec), (App)RecipeFunction.LIST_CODEC.fieldOf("function").forGetter(x -> x.functions)).apply((Applicative)instance, TransformShapedRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TransformShapedRecipe> STREAM_CODEC = StreamCodec.composite(ShapedRecipeSpec.STREAM_CODEC, CustomShapedRecipe::toSpec, RecipeFunction.LIST_STREAM_CODEC, x -> x.functions, TransformShapedRecipe::new);
    private final List<RecipeFunction> functions;

    public TransformShapedRecipe(ShapedRecipeSpec recipe, List<RecipeFunction> functions) {
        super(recipe);
        this.functions = functions;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider registryAccess) {
        ItemStack result = super.assemble(inventory, registryAccess);
        for (RecipeFunction function : this.functions) {
            result = function.apply(inventory, result);
        }
        return result;
    }

    public RecipeSerializer<TransformShapedRecipe> getSerializer() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.TRANSFORM_SHAPED.get();
    }
}

