/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.core.TerminalSize;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.items.ServerComputerReference;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.pocket.core.PocketBrain;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import dan200.computercraft.shared.util.StorageCapacity;
import java.util.Objects;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class PocketComputerItem
extends Item {
    private final ComputerFamily family;

    public PocketComputerItem(Item.Properties settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public void tick(ItemStack stack, PocketHolder holder, boolean passive) {
        PocketBrain brain;
        if (passive) {
            PocketServerComputer computer = PocketComputerItem.getServerComputer(holder.level().getServer(), stack);
            if (computer == null) {
                return;
            }
            brain = computer.getBrain();
        } else {
            brain = this.getOrCreateBrain(holder.level(), holder, stack);
            brain.computer().keepAlive();
        }
        UpgradeData<IPocketUpgrade> upgrade = brain.getUpgrade();
        if (upgrade != null) {
            upgrade.upgrade().update(brain, brain.computer().getPeripheral(ComputerSide.BACK));
        }
        if (this.updateItem(stack, brain)) {
            holder.setChanged();
        }
    }

    private boolean updateItem(ItemStack stack, PocketBrain brain) {
        boolean on;
        boolean changed = brain.updateItem(stack);
        PocketServerComputer computer = brain.computer();
        String label = computer.getLabel();
        if (!Objects.equals(label, this.getLabel(stack))) {
            changed = true;
            DataComponentUtil.setCustomName(stack, label);
        }
        if ((on = computer.isOn()) != PocketComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.set((DataComponentType)ModRegistry.DataComponents.ON.get(), (Object)on);
        }
        return changed;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int compartmentSlot, boolean selected) {
        if (world.isClientSide || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        int slot = InventoryUtil.getInventorySlotFromCompartment((Player)player, compartmentSlot, stack);
        if (slot < 0) {
            return;
        }
        this.tick(stack, new PocketHolder.PlayerHolder(player, slot), false);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.level();
        if (level.isClientSide || level.getServer() == null) {
            return false;
        }
        this.tick(stack, new PocketHolder.ItemEntityHolder(entity), true);
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            PocketHolder.PlayerHolder holder = new PocketHolder.PlayerHolder((ServerPlayer)player, InventoryUtil.getHandSlot(player, hand));
            PocketBrain brain = this.getOrCreateBrain((ServerLevel)world, holder, stack);
            PocketServerComputer computer = brain.computer();
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            if (upgrade != null) {
                stop = upgrade.onRightClick(world, brain, computer.getPeripheral(ComputerSide.BACK));
                this.updateItem(stack, brain);
            }
            if (!stop) {
                PocketComputerItem.openImpl(player, stack, holder, hand == InteractionHand.OFF_HAND, computer);
            }
        }
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)world.isClientSide), (Object)stack);
    }

    public void open(Player player, ItemStack stack, PocketHolder holder, boolean isTypingOnly) {
        PocketBrain brain = this.getOrCreateBrain(holder.level(), holder, stack);
        PocketServerComputer computer = brain.computer();
        computer.turnOn();
        PocketComputerItem.openImpl(player, stack, holder, isTypingOnly, computer);
    }

    private static void openImpl(Player player, ItemStack stack, PocketHolder holder, boolean isTypingOnly, ServerComputer computer) {
        PlatformHelper.get().openMenu(player, stack.getHoverName(), (id, inventory, entity) -> new ComputerMenuWithoutInventory((MenuType<? extends AbstractComputerMenu>)(isTypingOnly ? (MenuType)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get() : (MenuType)ModRegistry.Menus.COMPUTER.get()), id, inventory, p -> holder.isValid(computer), computer), new ComputerContainerData(computer, stack));
    }

    public Component getName(ItemStack stack) {
        String baseString = this.getDescriptionId(stack);
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null) {
            return Component.translatable((String)(baseString + ".upgraded"), (Object[])new Object[]{upgrade.getAdjective()});
        }
        return super.getName(stack);
    }

    public @Nullable String getCreatorModId(ItemStack stack) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        return upgrade != null ? PocketUpgrades.instance().getOwner(upgrade.holder()) : "computercraft";
    }

    private PocketBrain getOrCreateBrain(ServerLevel level, PocketHolder holder, ItemStack stack) {
        ServerComputerRegistry registry = ServerContext.get(level.getServer()).registry();
        PocketServerComputer computer = PocketComputerItem.getServerComputer(registry, stack);
        if (computer != null) {
            PocketBrain brain = computer.getBrain();
            brain.updateHolder(holder);
            return brain;
        }
        int computerID = NonNegativeId.getOrCreate(level.getServer(), stack, (DataComponentType<NonNegativeId>)((DataComponentType)ModRegistry.DataComponents.COMPUTER_ID.get()), "computer");
        PocketBrain brain = new PocketBrain(holder, PocketComputerItem.getUpgradeWithData(stack), DyedItemColor.getOrDefault((ItemStack)stack, (int)-1), ServerComputer.properties(computerID, this.getFamily()).label(this.getLabel(stack)).storageCapacity(StorageCapacity.getOrDefault((StorageCapacity)stack.get((DataComponentType)ModRegistry.DataComponents.STORAGE_CAPACITY.get()), -1L)).terminalSize((TerminalSize)stack.getOrDefault((DataComponentType)ModRegistry.DataComponents.TERMINAL_SIZE.get(), (Object)new TerminalSize((Integer)ConfigSpec.pocketTermWidth.get(), (Integer)ConfigSpec.pocketTermHeight.get()))));
        PocketServerComputer computer2 = brain.computer();
        stack.set((DataComponentType)ModRegistry.DataComponents.COMPUTER.get(), (Object)new ServerComputerReference(registry.getSessionID(), computer2.register()));
        if (PocketComputerItem.isMarkedOn(stack)) {
            computer2.turnOn();
        }
        this.updateItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static boolean isServerComputer(ServerComputer computer, ItemStack stack) {
        return stack.getItem() instanceof PocketComputerItem && PocketComputerItem.getServerComputer(computer.getLevel().getServer(), stack) == computer;
    }

    public static @Nullable PocketServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        return (PocketServerComputer)ServerComputerReference.get((DataComponentHolder)stack, registry);
    }

    public static @Nullable PocketServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        return PocketComputerItem.getServerComputer(ServerContext.get(server).registry(), stack);
    }

    public void onCraftedPostProcess(ItemStack stack, Level level) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            return;
        }
        PocketServerComputer computer = PocketComputerItem.getServerComputer(server, stack);
        if (computer == null) {
            return;
        }
        PocketBrain brain = computer.getBrain();
        brain.setUpgrade(PocketComputerItem.getUpgradeWithData(stack));
        brain.setColour(DyedItemColor.getOrDefault((ItemStack)stack, (int)-1));
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    private @Nullable String getLabel(ItemStack stack) {
        return DataComponentUtil.getCustomName((DataComponentHolder)stack);
    }

    private static boolean isMarkedOn(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)ModRegistry.DataComponents.ON.get(), (Object)false);
    }

    public static @Nullable IPocketUpgrade getUpgrade(ItemStack stack) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        return upgrade == null ? null : upgrade.upgrade();
    }

    public static @Nullable UpgradeData<IPocketUpgrade> getUpgradeWithData(ItemStack stack) {
        return (UpgradeData)stack.get((DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get());
    }

    public static void setUpgrade(ItemStack stack, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        stack.set((DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get(), upgrade);
    }
}

