/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public class PocketAPI
implements ILuaAPI {
    private final IPocketAccess pocket;

    public PocketAPI(IPocketAccess pocket) {
        this.pocket = pocket;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBack() {
        Entity entity = this.pocket.getEntity();
        if (!(entity instanceof Player)) {
            return new Object[]{false, "Cannot find player"};
        }
        Player player = (Player)entity;
        Inventory inventory = player.getInventory();
        UpgradeData<IPocketUpgrade> previousUpgrade = this.pocket.getUpgrade();
        UpgradeData<IPocketUpgrade> newUpgrade = this.findUpgrade((NonNullList<ItemStack>)inventory.items, inventory.selected, previousUpgrade);
        if (newUpgrade == null) {
            newUpgrade = this.findUpgrade((NonNullList<ItemStack>)inventory.offhand, 0, previousUpgrade);
        }
        if (newUpgrade == null) {
            return new Object[]{false, "Cannot find a valid upgrade"};
        }
        if (previousUpgrade != null) {
            PocketAPI.storeItem(player, previousUpgrade.getUpgradeItem());
        }
        this.pocket.setUpgrade(newUpgrade);
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBack() {
        Entity entity = this.pocket.getEntity();
        if (!(entity instanceof Player)) {
            return new Object[]{false, "Cannot find player"};
        }
        Player player = (Player)entity;
        UpgradeData<IPocketUpgrade> previousUpgrade = this.pocket.getUpgrade();
        if (previousUpgrade == null) {
            return new Object[]{false, "Nothing to unequip"};
        }
        this.pocket.setUpgrade(null);
        PocketAPI.storeItem(player, previousUpgrade.getUpgradeItem());
        return new Object[]{true};
    }

    private static void storeItem(Player player, ItemStack stack) {
        ItemEntity drop;
        if (!stack.isEmpty() && !player.getInventory().add(stack) && (drop = player.drop(stack, false)) != null) {
            drop.setNoPickUpDelay();
        }
    }

    private @Nullable UpgradeData<IPocketUpgrade> findUpgrade(NonNullList<ItemStack> inv, int start, @Nullable UpgradeData<IPocketUpgrade> previous) {
        for (int i = 0; i < inv.size(); ++i) {
            UpgradeData<IPocketUpgrade> newUpgrade;
            ItemStack invStack = (ItemStack)inv.get((i + start) % inv.size());
            if (invStack.isEmpty() || (newUpgrade = PocketUpgrades.instance().get((HolderLookup.Provider)this.pocket.getLevel().registryAccess(), invStack)) == null || Objects.equals(newUpgrade, previous)) continue;
            invStack = invStack.copy();
            invStack.shrink(1);
            inv.set((i + start) % inv.size(), (Object)(invStack.isEmpty() ? ItemStack.EMPTY : invStack));
            return newUpgrade;
        }
        return null;
    }
}

