/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.LevelChunk;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.IScreenBase;
import xaero.common.misc.IObfuscatedReflection;
import xaero.common.platform.Services;
import xaero.hud.controls.key.IKeyBindingHelper;
import xaero.hud.minimap.MinimapLogs;

public class Misc {
    public static double getMouseX(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.mouseHandler.xpos();
        }
        return mc.mouseHandler.xpos() * (double)mc.getWindow().getWidth() / (double)mc.getWindow().getScreenWidth();
    }

    public static double getMouseY(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.mouseHandler.ypos();
        }
        return mc.mouseHandler.ypos() * (double)mc.getWindow().getHeight() / (double)mc.getWindow().getScreenHeight();
    }

    public static void drawNormalText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void drawNormalText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void drawPiercingText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    public static void drawPiercingText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.getInstance().font.width(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.getInstance().font.width((FormattedText)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static void deleteFile(Path file, int attempts) throws IOException {
        --attempts;
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    if (iOException != null) {
                        throw iOException;
                    }
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            if (attempts > 0) {
                MinimapLogs.LOGGER.info("Failed to delete file/folder! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.deleteFile(file, attempts);
            }
            throw e;
        }
    }

    public static boolean inputMatchesKeyBinding(IXaeroMinimap modMain, InputConstants.Type type, int code, KeyMapping kb, int keyConflictContext) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        return kb != null && code != -1 && keyBindingHelper.getBoundKeyOf(kb).getType() == type && keyBindingHelper.getBoundKeyOf(kb).getValue() == code && keyBindingHelper.modifiersAreActive(kb, keyConflictContext);
    }

    public static boolean screenShouldSkipWorldRender(IXaeroMinimap modMain, Screen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && modMain.getSupportMods().worldmap() && modMain.getSupportMods().worldmapSupport.screenShouldSkipWorldRender(screen);
    }

    public static long getChunkPosAsLong(LevelChunk chunk) {
        return chunk.getPos().toLong();
    }

    public static Class<?> getClassForName(String obfuscatedName, String deobfName) throws ClassNotFoundException {
        IObfuscatedReflection obfuscatedReflection = Services.PLATFORM.getObfuscatedReflection();
        return obfuscatedReflection.getClassForName(obfuscatedName, deobfName);
    }

    public static Field getFieldReflection(Class<?> c, String deobfName, String obfuscatedNameFabric, String descriptor, String obfuscatedNameForge) {
        IObfuscatedReflection obfuscatedReflection = Services.PLATFORM.getObfuscatedReflection();
        return obfuscatedReflection.getFieldReflection(c, deobfName, obfuscatedNameFabric, descriptor, obfuscatedNameForge);
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static <A, B> void setReflectFieldValue(A parentObject, Field field, B value) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(parentObject, value);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
    }

    public static Method getMethodReflection(Class<?> c, String deobfName, String obfuscatedNameFabric, String descriptor, String obfuscatedNameForge, Class<?> ... parameters) {
        IObfuscatedReflection obfuscatedReflection = Services.PLATFORM.getObfuscatedReflection();
        return obfuscatedReflection.getMethodReflection(c, deobfName, obfuscatedNameFabric, descriptor, obfuscatedNameForge, parameters);
    }

    public static <A, B> B getReflectMethodValue(A parentObject, Method method, Object ... arguments) {
        boolean accessibleBU = method.isAccessible();
        method.setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(parentObject, arguments);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        method.setAccessible(accessibleBU);
        return (B)result;
    }

    public static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }

    public static boolean hasItem(Player player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.getInventory().offhand, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.getInventory().armor, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.getInventory().items, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static void setFieldText(EditBox field, String text) {
        Misc.setFieldText(field, text, -1);
    }

    public static void setFieldText(EditBox field, String text, int color) {
        field.setTextColor(color);
        if (field.getValue().equals(text)) {
            return;
        }
        field.setValue(text);
    }

    public static Component getFixedDisplayName(Entity e) {
        Component baseName = e.getName();
        if (baseName == null) {
            return null;
        }
        return e.getTeam() == null ? baseName.copy() : e.getTeam().getFormattedName((Component)baseName.copy());
    }

    public static boolean hasEffect(Player player, Holder<MobEffect> effect) {
        return effect != null && player.hasEffect(effect);
    }

    public static boolean hasEffect(Holder<MobEffect> effect) {
        return Misc.hasEffect((Player)Minecraft.getInstance().player, effect);
    }

    public static boolean isValidResourceLocationString(String resourceLocationString) {
        if (resourceLocationString.isEmpty()) {
            return false;
        }
        for (int i = 0; i < resourceLocationString.length(); ++i) {
            if (ResourceLocation.isAllowedInResourceLocation((char)resourceLocationString.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

