/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.tpa.event;

import fox.mods.tpa.TpaManager;
import fox.mods.tpa.config.TpaConfiguration;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class PlayerTickUpdate {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        PlayerTickUpdate.execute((Event)event, event.getEntity());
    }

    public static void execute(Player entity) {
        PlayerTickUpdate.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Player player) {
        if (player == null) {
            return;
        }
        boolean inCooldown = TpaManager.inCooldown(player);
        double cooldown = TpaManager.getCooldown(player);
        double teleportTime = TpaManager.getTeleportTime(player);
        boolean teleporting = TpaManager.isTeleporting(player);
        boolean backInCooldown = TpaManager.backInCooldown(player);
        double backCooldown = TpaManager.getBackCooldown(player);
        if (inCooldown) {
            TpaManager.setCooldown(player, cooldown - 0.05);
        }
        if (cooldown <= 0.0) {
            TpaManager.setInCooldown(player, false);
            TpaManager.setCooldown(player, TpaConfiguration.cooldown);
        }
        if (backInCooldown) {
            TpaManager.setBackCooldown(player, backCooldown - 0.05);
        }
        if (backCooldown <= 0.0) {
            TpaManager.setBackInCooldown(player, false);
            TpaManager.setBackCooldown(player, TpaConfiguration.backCooldown);
        }
    }
}

