/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.tpa.config;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="tpa", bus=EventBusSubscriber.Bus.MOD)
public class TpaConfiguration {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.DoubleValue COOLDOWN = BUILDER.comment("\n Cooldown the player has to wait after using the tpa command.").defineInRange("tpaCooldown", 30.0, 5.0, 900.0);
    private static final ModConfigSpec.DoubleValue TELEPORT_TIME = BUILDER.comment("\n Time waited to teleport after a request is accepted").defineInRange("teleportTime", 5.0, 1.0, 60.0);
    private static final ModConfigSpec.BooleanValue BACK_ENABLED = BUILDER.comment("\n If teleporting back with the back command is enabled").define("backEnabled", true);
    private static final ModConfigSpec.DoubleValue BACK_COOLDOWN = BUILDER.comment("\n Cooldown the player has to wait after using the back command.").defineInRange("backCooldown", 30.0, 1.0, 900.0);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static double cooldown;
    public static double teleportTime;
    public static boolean backEnabled;
    public static double backCooldown;

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        cooldown = (Double)COOLDOWN.get();
        teleportTime = (Double)TELEPORT_TIME.get();
        backEnabled = (Boolean)BACK_ENABLED.get();
        backCooldown = (Double)BACK_COOLDOWN.get();
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        cooldown = (Double)COOLDOWN.get();
        teleportTime = (Double)TELEPORT_TIME.get();
        backEnabled = (Boolean)BACK_ENABLED.get();
        backCooldown = (Double)BACK_COOLDOWN.get();
    }
}

