/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.tpa;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fox.mods.tpa.TpaMod;
import fox.mods.tpa.config.TpaConfiguration;
import fox.mods.tpa.network.TpaModVariables;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TpaManager {
    public static void sendTpaRequest(Player sender, CommandContext<CommandSourceStack> arguments) {
        Player receiver = TpaManager.commandParameterEntity(arguments, "player");
        if (receiver == null) {
            return;
        }
        boolean inCooldown = TpaManager.inCooldown(sender);
        double cooldown = 0.0;
        boolean toggled = TpaManager.isToggled(receiver);
        if (inCooldown) {
            cooldown = TpaManager.getCooldown(sender);
            sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "You're still in cooldown!" + ChatFormatting.GRAY.toString() + " (" + (int)cooldown + "s)")), true);
            return;
        }
        if (!toggled) {
            sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + receiver.getName().getString() + " has teleport requests disabled.")), true);
            return;
        }
        if (sender == receiver) {
            sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "You cannot teleport to yourself!")), true);
            return;
        }
        UUID senderUUID = sender.getUUID();
        UUID receiverUUID = receiver.getUUID();
        Path dataDir = Path.of("config", "tpa", "data");
        Path file = dataDir.resolve(String.valueOf(receiverUUID) + ".json");
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
            JsonObject obj = new JsonObject();
            obj.addProperty("sender", senderUUID.toString());
            obj.addProperty("receiver", receiverUUID.toString());
            obj.addProperty("type", "tpa");
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TpaManager.setInCooldown(sender, true);
        receiver.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + sender.getName().getString() + ChatFormatting.GOLD.toString() + " has sent you a teleport request!")), true);
        sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "You sent a teleport request!")), true);
    }

    private static Player commandParameterEntity(CommandContext<CommandSourceStack> arguments, String parameter) {
        try {
            Entity entity = EntityArgument.getEntity(arguments, (String)parameter);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return player;
            }
            return null;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setInCooldown(Player player, boolean value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.tpaInCooldown = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void toggle(Player player, boolean value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.tpaToggled = value;
        _vars.syncPlayerVariables((Entity)player);
        if (value) {
            player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "Teleport requests are now " + ChatFormatting.RED.toString() + "enabled")), true);
        } else {
            player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "Teleport requests are now " + ChatFormatting.RED.toString() + "disabled")), true);
        }
    }

    public static void setCooldown(Player player, double value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.tpaCooldown = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void setTeleporting(Player player, boolean value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.teleporting = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void setTeleportTime(Player player, double value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.teleportTime = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static double getCooldown(Player player) {
        double cooldown = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).tpaCooldown;
        return cooldown;
    }

    public static double getTeleportTime(Player player) {
        double teleportTime = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).teleportTime;
        return teleportTime;
    }

    public static boolean inCooldown(Player player) {
        boolean inCooldown = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).tpaInCooldown;
        return inCooldown;
    }

    public static boolean isToggled(Player player) {
        boolean toggled = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).tpaToggled;
        return toggled;
    }

    public static boolean isTeleporting(Player player) {
        boolean teleporting = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).teleporting;
        return teleporting;
    }

    public static BlockPos backPos(Player player) {
        double backX = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).backX;
        double backY = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).backY;
        double backZ = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).backZ;
        return BlockPos.containing((double)backX, (double)backY, (double)backZ);
    }

    public static Level backDimension(Player player) {
        String backDimension = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).backDimension;
        ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)backDimension));
        ServerLevel level = player.getServer().getLevel(dimensionKey);
        return level;
    }

    public static double getBackCooldown(Player player) {
        double cooldown = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).backCooldown;
        return cooldown;
    }

    public static boolean backInCooldown(Player player) {
        boolean inCooldown = ((TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES)).backInCooldown;
        return inCooldown;
    }

    public static void setBackInCooldown(Player player, boolean value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.backInCooldown = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void setBackCooldown(Player player, double value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.backCooldown = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void setBackX(Player player, double value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.backX = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void setBackY(Player player, double value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.backY = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void setBackZ(Player player, double value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.backZ = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void setBackDimension(Player player, String value) {
        TpaModVariables.PlayerVariables _vars = (TpaModVariables.PlayerVariables)player.getData(TpaModVariables.PLAYER_VARIABLES);
        _vars.backDimension = value;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void acceptTpaRequest(Player receiver) {
        UUID receiverUUID = receiver.getUUID();
        UUID senderUUID = null;
        String tpaType = "";
        Path file = Path.of("config", "tpa", "data", String.valueOf(receiverUUID) + ".json");
        if (!Files.exists(file, new LinkOption[0])) {
            receiver.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "You don't have a teleport request!")), true);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            senderUUID = UUID.fromString(obj.get("sender").getAsString());
            tpaType = obj.get("type").getAsString();
            Files.delete(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (senderUUID == null) {
            TpaManager.showCancelError(receiver);
            return;
        }
        ServerPlayer serverSender = null;
        if (receiver instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)receiver;
            if (serverPlayer.getServer() == null) {
                TpaManager.showCancelError(receiver);
                return;
            }
            serverSender = TpaManager.getPlayerFromUUID(serverPlayer.getServer(), senderUUID);
        }
        if (serverSender == null) {
            TpaManager.showCancelError(receiver);
            return;
        }
        ServerPlayer sender = serverSender;
        if (tpaType.equals("tpa")) {
            receiver.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "You accepted the teleport request!")), true);
            TpaManager.setTeleporting((Player)sender, true);
            double teleportTime = TpaConfiguration.teleportTime;
            sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "Your teleport request was accepted! Teleporting in " + ChatFormatting.RED.toString() + (int)teleportTime + "s...")), true);
            TpaMod.queueServerWork(20 * (int)teleportTime, () -> TpaManager.lambda$acceptTpaRequest$0((Player)sender, receiver));
        } else if (tpaType.equals("tpahere")) {
            TpaManager.setTeleporting(receiver, true);
            double teleportTime = TpaConfiguration.teleportTime;
            receiver.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "You accepted the teleport request! Teleporting in " + ChatFormatting.RED.toString() + (int)teleportTime + "s...")), true);
            sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "Your teleport request was accepted!")), true);
            TpaMod.queueServerWork(20 * (int)teleportTime, () -> TpaManager.lambda$acceptTpaRequest$1(receiver, (Player)sender));
        }
    }

    public static ServerPlayer getPlayerFromUUID(MinecraftServer server, UUID uuid) {
        return server.getPlayerList().getPlayer(uuid);
    }

    private static void showCancelError(Player player) {
        player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "The teleport request was cancelled")), true);
    }

    public static void teleportPlayerToPlayer(Player stayer, Player teleported) {
        double x = stayer.getX();
        double y = stayer.getY();
        double z = stayer.getZ();
        teleported.teleportTo(x, y, z);
        if (teleported instanceof ServerPlayer) {
            ServerPlayer _serverPlayer = (ServerPlayer)teleported;
            _serverPlayer.connection.teleport(x, y, z, teleported.getYRot(), teleported.getXRot());
        }
        teleported.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "Teleported!")), true);
        stayer.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "Teleported!")), true);
        TpaManager.setTeleporting(teleported, false);
        TpaManager.setTeleportTime(teleported, TpaConfiguration.teleportTime);
    }

    public static void teleportPlayerToLocation(Player player, BlockPos pos) {
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        player.teleportTo(x, y, z);
        if (player instanceof ServerPlayer) {
            ServerPlayer _serverPlayer = (ServerPlayer)player;
            _serverPlayer.connection.teleport(x, y, z, player.getYRot(), player.getXRot());
        }
        player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "Teleported!")), true);
    }

    public static void changePlayerDimension(Player player, Level level) {
        ServerPlayer _player;
        if (player instanceof ServerPlayer && !(_player = (ServerPlayer)player).level().isClientSide()) {
            ResourceKey destinationType = level.dimension();
            if (_player.level().dimension() == destinationType) {
                return;
            }
            ServerLevel nextLevel = _player.server.getLevel(destinationType);
            if (nextLevel != null) {
                _player.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, 0.0f));
                _player.teleportTo(nextLevel, _player.getX(), _player.getY(), _player.getZ(), Set.of(), _player.getYRot(), _player.getXRot(), true);
                _player.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(_player.getAbilities()));
                for (MobEffectInstance _effectinstance : _player.getActiveEffects()) {
                    _player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(_player.getId(), _effectinstance, false));
                }
                _player.connection.send((Packet)new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
            }
        }
    }

    public static void sendTpaHereRequest(Player sender, CommandContext<CommandSourceStack> arguments) {
        Player receiver = TpaManager.commandParameterEntity(arguments, "player");
        if (receiver == null) {
            return;
        }
        boolean inCooldown = TpaManager.inCooldown(sender);
        double cooldown = 0.0;
        boolean toggled = TpaManager.isToggled(receiver);
        if (inCooldown) {
            cooldown = TpaManager.getCooldown(sender);
            sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "You're still in cooldown!" + ChatFormatting.GRAY.toString() + " (" + (int)cooldown + "s)")), true);
            return;
        }
        if (!toggled) {
            sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + receiver.getName().getString() + " has teleport requests disabled.")), true);
            return;
        }
        if (sender == receiver) {
            sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "You cannot teleport to yourself!")), true);
            return;
        }
        UUID senderUUID = sender.getUUID();
        UUID receiverUUID = receiver.getUUID();
        Path dataDir = Path.of("config", "tpa", "data");
        Path file = dataDir.resolve(String.valueOf(receiverUUID) + ".json");
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
            JsonObject obj = new JsonObject();
            obj.addProperty("sender", senderUUID.toString());
            obj.addProperty("receiver", receiverUUID.toString());
            obj.addProperty("type", "tpahere");
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TpaManager.setInCooldown(sender, true);
        receiver.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + sender.getName().getString() + ChatFormatting.GOLD.toString() + " has sent you a teleport here request!")), true);
        sender.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "You sent a teleport here request!")), true);
    }

    public static void teleportBack(Player player) {
        boolean inCooldown = TpaManager.backInCooldown(player);
        boolean enabled = TpaConfiguration.backEnabled;
        if (inCooldown) {
            double cooldown = TpaManager.getBackCooldown(player);
            player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "You're still in cooldown!" + ChatFormatting.GRAY.toString() + " (" + (int)cooldown + "s)")), true);
            return;
        }
        if (!enabled) {
            player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "/back is disabled!")), true);
            return;
        }
        BlockPos backPos = TpaManager.backPos(player);
        Level backDimension = TpaManager.backDimension(player);
        if (backDimension == null || backPos.getX() == 0 && backPos.getY() == 0 && backPos.getZ() == 0) {
            player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.RED.toString() + "No back location")), true);
            return;
        }
        player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.GOLD.toString() + "Teleporting in " + ChatFormatting.RED.toString() + (int)TpaConfiguration.teleportTime + ChatFormatting.GOLD.toString() + "s...")), true);
        TpaMod.queueServerWork(20 * (int)TpaConfiguration.teleportTime, () -> {
            TpaManager.changePlayerDimension(player, backDimension);
            TpaManager.teleportPlayerToLocation(player, backPos);
            TpaManager.setBackX(player, 0.0);
            TpaManager.setBackY(player, 0.0);
            TpaManager.setBackZ(player, 0.0);
            TpaManager.setBackDimension(player, Level.OVERWORLD.location().toString());
            TpaManager.setBackInCooldown(player, true);
        });
    }

    private static /* synthetic */ void lambda$acceptTpaRequest$1(Player receiver, Player sender) {
        TpaManager.setBackX(receiver, receiver.getX());
        TpaManager.setBackY(receiver, receiver.getY());
        TpaManager.setBackZ(receiver, receiver.getZ());
        TpaManager.setBackDimension(receiver, receiver.level().dimension().location().toString());
        TpaManager.teleportPlayerToPlayer(sender, receiver);
    }

    private static /* synthetic */ void lambda$acceptTpaRequest$0(Player sender, Player receiver) {
        TpaManager.setBackX(sender, sender.getX());
        TpaManager.setBackY(sender, sender.getY());
        TpaManager.setBackZ(sender, sender.getZ());
        TpaManager.setBackDimension(sender, sender.level().dimension().location().toString());
        TpaManager.teleportPlayerToPlayer(receiver, sender);
    }
}

