/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.mixin;

import java.util.Objects;
import net.dakotapride.garnished.registry.GarnishedEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, remap=false)
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    LivingEntity entity = (LivingEntity)this;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    private void spiritedResistanceImmunity$tickEffects(CallbackInfo ci) {
        if (this.entity.hasEffect(GarnishedEffects.SPIRITED_RESISTANCE)) {
            if (this.entity.hasEffect(MobEffects.WITHER)) {
                this.entity.removeEffect(MobEffects.WITHER);
            }
            if (this.entity.hasEffect(MobEffects.CONFUSION)) {
                this.entity.removeEffect(MobEffects.CONFUSION);
            }
            if (this.entity.hasEffect(MobEffects.BLINDNESS)) {
                this.entity.removeEffect(MobEffects.BLINDNESS);
            }
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="HEAD")})
    private void spiritedResistanceThorns$getDamageAfterMagicAbsorb(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            boolean isSkeleton = attacker instanceof Skeleton;
            boolean isWitherSkeleton = attacker instanceof WitherSkeleton;
            boolean isWither = attacker instanceof WitherBoss;
            boolean isGhast = attacker instanceof Ghast;
            if (this.entity.hasEffect(GarnishedEffects.SPIRITED_RESISTANCE) && (isSkeleton || isWitherSkeleton || isWither || isGhast)) {
                attacker.hurt(source, amount * 1.336745f);
            }
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="HEAD")})
    private void applyThornsDamage$getDamageAfterMagicAbsorb(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            float j = amount / 2.0f;
            boolean f = j <= 3.0f;
            DeferredHolder<MobEffect, MobEffect> e = GarnishedEffects.THORNS;
            if (f) {
                j = 4.0f;
            }
            if (this.entity.hasEffect(e) && !attacker.hasEffect(e)) {
                attacker.hurt(source, j);
            } else if (j > attacker.getMaxHealth() * 0.8f && this.entity.hasEffect(e) && !attacker.hasEffect(e)) {
                attacker.hurt(source, attacker.getMaxHealth() * 0.8f);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void negateArrowDamage$hurt(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        int j;
        int k;
        DeferredHolder<MobEffect, MobEffect> truthSeekerMobEffect;
        int effectAmplifier;
        int boundInt;
        int negateChance;
        if (this.entity.hasEffect(GarnishedEffects.TRUTH_SEEKER) && pSource.getDirectEntity() instanceof AbstractArrow && this.entity.getEffect(GarnishedEffects.TRUTH_SEEKER) != null && (negateChance = (boundInt = 20 - (effectAmplifier = Objects.requireNonNull(this.entity.getEffect(truthSeekerMobEffect = GarnishedEffects.TRUTH_SEEKER)).getAmplifier())) <= 0 ? this.entity.getRandom().nextInt(1) : this.entity.getRandom().nextInt(boundInt + 1)) <= (k = (j = this.entity.getRandom().nextInt(10)) + 10)) {
            cir.setReturnValue((Object)false);
        }
    }
}

