/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.mixin;

import com.simibubi.create.api.event.PipeCollisionEvent;
import com.simibubi.create.content.fluids.FluidReactions;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.dakotapride.garnished.registry.GarnishedFluids;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidReactions.class}, remap=false)
public class FluidReactionsMixin {
    @Inject(method={"handlePipeFlowCollisionFallback"}, at={@At(value="HEAD")})
    private static void handlePipeFlowCollisionFallback(PipeCollisionEvent.Flow event, CallbackInfo ci) {
        BlockState lavaInteraction;
        Fluid f1 = event.getFirstFluid();
        Fluid f2 = event.getSecondFluid();
        if (f1 == Fluids.LAVA && FluidHelper.hasBlockState((Fluid)f2)) {
            BlockState lavaInteraction2 = GarnishedFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)f2).defaultFluidState());
            if (lavaInteraction2 != null) {
                event.setState(lavaInteraction2);
            }
        } else if (f2 == Fluids.LAVA && FluidHelper.hasBlockState((Fluid)f1) && (lavaInteraction = GarnishedFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)f1).defaultFluidState())) != null) {
            event.setState(lavaInteraction);
        }
    }

    @Inject(method={"handlePipeSpillCollisionFallback"}, at={@At(value="HEAD")})
    private static void handlePipeSpillCollisionFallback(PipeCollisionEvent.Spill event, CallbackInfo ci) {
        BlockState lavaInteraction;
        Fluid pf = event.getPipeFluid();
        Fluid wf = event.getWorldFluid();
        if (FluidHelper.isTag((Fluid)pf, (TagKey)FluidTags.WATER) && wf == Fluids.LAVA) {
            event.setState(Blocks.OBSIDIAN.defaultBlockState());
        }
        if (pf == Fluids.LAVA) {
            BlockState lavaInteraction2 = GarnishedFluids.getLavaInteraction(wf.defaultFluidState());
            if (lavaInteraction2 != null) {
                event.setState(lavaInteraction2);
            }
        } else if (wf == Fluids.FLOWING_LAVA && FluidHelper.hasBlockState((Fluid)pf) && (lavaInteraction = GarnishedFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)pf).defaultFluidState())) != null) {
            event.setState(lavaInteraction);
        }
    }
}

