/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item;

import java.util.List;
import net.dakotapride.garnished.item.ConditionalEffectItem;
import net.dakotapride.garnished.item.IGarnishedUtilities;
import net.dakotapride.garnished.registry.GarnishedFoodValues;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrypticAppleCiderFoodItem
extends ConditionalEffectItem
implements IGarnishedUtilities {
    private static final int DRINK_DURATION = 40;

    public CrypticAppleCiderFoodItem(Item.Properties properties) {
        super(6, 100.0f, properties.stacksTo(8).food(GarnishedFoodValues.CRYPTIC_APPLE_CIDER));
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag isAdvanced) {
        tooltip.add((Component)Component.translatable((String)"text.garnished.effect.clears_wither", (Object[])new Object[]{"Wither"}).withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.literal((String)""));
        this.addEffectTooltip(tooltip, MobEffects.DAMAGE_BOOST, 900.0f);
        this.addChanceForEffect(tooltip, 50.0f);
        this.addEffectTooltip(tooltip, MobEffects.MOVEMENT_SLOWDOWN, 900.0f);
        this.addChanceForEffect(tooltip, 50.0f);
    }

    @Override
    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!level.isClientSide) {
            livingEntity.removeEffect(MobEffects.WITHER);
        }
        if (stack.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (livingEntity instanceof Player && !((Player)livingEntity).getAbilities().instabuild) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            Player player = (Player)livingEntity;
            if (!player.getInventory().add(itemStack)) {
                player.drop(itemStack, false);
            }
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    public int getUseDuration(@NotNull ItemStack stack, LivingEntity entity) {
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public SoundEvent getDrinkingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    @NotNull
    public SoundEvent getEatingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
    }
}

