/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.entity.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.dakotapride.garnished.CreateGarnished;
import net.dakotapride.garnished.entity.boat.NutBoatEntity;
import net.dakotapride.garnished.entity.boat.NutChestBoatEntity;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class NutBoatRenderer
extends BoatRenderer {
    private final Map<NutBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(NutBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)CreateGarnished.asResource(NutBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (NutBoatEntity.Type)((Object)type), pChestBoat))));

    public NutBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(NutBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, NutBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? NutBoatRenderer.createChestBoatModelName(pType) : NutBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.bakeLayer(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(NutBoatEntity.Type pType) {
        return NutBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(NutBoatEntity.Type pType) {
        return NutBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(CreateGarnished.asResource(pPath), pModel);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof NutBoatEntity) {
            NutBoatEntity modBoat = (NutBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getModVariant());
        }
        if (boat instanceof NutChestBoatEntity) {
            NutChestBoatEntity modChestBoatEntity = (NutChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getModVariant());
        }
        return null;
    }
}

