/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.block;

import net.dakotapride.garnished.item.IGarnishedUtilities;
import net.dakotapride.garnished.registry.GarnishedEffects;
import net.dakotapride.garnished.registry.GarnishedTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class NumbingParchmentBlock
extends Block
implements IGarnishedUtilities {
    public NumbingParchmentBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void stepOn(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && !((living = (LivingEntity)entity) instanceof Stray) && !(living instanceof PolarBear) && !living.isSteppingCarefully()) {
            if (EnchantmentHelper.hasTag((ItemStack)living.getItemBySlot(EquipmentSlot.FEET), GarnishedTags.FROST_WALKER)) {
                living.addEffect(new MobEffectInstance(GarnishedEffects.FREEZING, 240, 0));
                living.setTicksFrozen(300);
            } else {
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 1));
            }
        }
    }

    public static class Carpet
    extends CarpetBlock
    implements IGarnishedUtilities {
        public Carpet(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
            LivingEntity living;
            if (entity instanceof LivingEntity && !((living = (LivingEntity)entity) instanceof Stray) && !(living instanceof PolarBear) && !living.isSteppingCarefully()) {
                if (EnchantmentHelper.hasTag((ItemStack)living.getItemBySlot(EquipmentSlot.FEET), GarnishedTags.FROST_WALKER)) {
                    living.addEffect(new MobEffectInstance(GarnishedEffects.FREEZING, 240, 0));
                    living.setTicksFrozen(300);
                } else {
                    living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 1));
                }
            }
        }
    }
}

