/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class SoundHelper {
    private static final Map<ResourceLocation, ScheduledExecutorService> soundSchedulers = new ConcurrentHashMap<ResourceLocation, ScheduledExecutorService>();

    public static void loopSound(LivingEntity entity, ResourceLocation soundId, int soundDurationSeconds, int updateFrequencyTicks) {
        if (entity.level().isClientSide()) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)entity.level();
        SoundEvent soundEvent = (SoundEvent)SoundRegistry.SOUND.getRegistrar().get(soundId);
        if (soundSchedulers.containsKey(soundId)) {
            return;
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        soundSchedulers.put(soundId, scheduler);
        int totalTicks = soundDurationSeconds * 20;
        int[] elapsedTicks = new int[]{0};
        scheduler.scheduleAtFixedRate(() -> {
            elapsedTicks[0] = elapsedTicks[0] + updateFrequencyTicks;
            if (entity.isAlive() && elapsedTicks[0] < totalTicks && entity.hasEffect(EffectRegistry.getReference(EffectRegistry.ELEMENTAL_VORTEX))) {
                float playbackProgress = (float)(elapsedTicks[0] % totalTicks) / (float)totalTicks;
                float pitch = 1.0f + playbackProgress * 0.2f;
                serverWorld.playSound(null, entity.blockPosition(), soundEvent, entity.getSoundSource(), 1.0f, pitch);
            } else {
                SoundHelper.stopLoopingSound(entity, soundId);
            }
        }, 0L, (long)updateFrequencyTicks * 50L, TimeUnit.MILLISECONDS);
    }

    public static void stopLoopingSound(LivingEntity entity, ResourceLocation soundId) {
        ScheduledExecutorService scheduler = soundSchedulers.remove(soundId);
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
    }
}

