/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.entity.ThrownRunicEntity;
import net.sweenus.simplyswords.power.RunicGemPower;
import net.sweenus.simplyswords.registry.TagRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class ThrowingPower
extends RunicGemPower {
    public ThrowingPower() {
        super(false);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, ItemStack itemStack) {
        if (!world.isClientSide) {
            if (TagRegistry.isInTag(TagRegistry.spearsTag, itemStack.getItem())) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            itemStack = user.getItemInHand(hand);
            ThrownRunicEntity thrownSwordEntity = new ThrownRunicEntity(world, (LivingEntity)user, itemStack.copy());
            thrownSwordEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            thrownSwordEntity.setYRot(user.getYRot());
            thrownSwordEntity.setXRot(user.getXRot());
            double[] doubles = HelperMethods.getAttackFromSlot(user, itemStack, user.getUsedItemHand());
            thrownSwordEntity.primaryBaseDamage = (float)doubles[0];
            float weight = 0.01f;
            if (TagRegistry.isInTag(TagRegistry.lightWeaponsTag, itemStack.getItem())) {
                weight = 0.09f;
            } else if (TagRegistry.isInTag(TagRegistry.mediumWeaponsTag, itemStack.getItem())) {
                weight = 0.13f;
            } else if (TagRegistry.isInTag(TagRegistry.heavyWeaponsTag, itemStack.getItem())) {
                weight = 0.2f;
            }
            thrownSwordEntity.weightValue = weight;
            if (hand == InteractionHand.OFF_HAND) {
                thrownSwordEntity.offhandThrow = true;
            }
            thrownSwordEntity.setPosRaw(user.getX(), user.getEyeY() - 0.5, user.getZ());
            world.addFreshEntity((Entity)thrownSwordEntity);
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        user.swing(hand);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.throwingsworditem.tooltip1").setStyle(Styles.RUNIC));
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.throwingsworditem.tooltip2")).setStyle(Styles.RUNIC_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.throwingsworditem.tooltip3")).setStyle(Styles.RUNIC_DESCRIPTION));
        }
    }
}

