/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.entity.SimplySwordsBeeEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class HiveheartSwordItem
extends UniqueSwordItem {
    public HiveheartSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            SimplySwordsBeeEntity beeEntity;
            Player player;
            ServerLevel serverWorld = (ServerLevel)attacker.level();
            int skillCooldown = Config.uniqueEffects.hiveheart.cooldown;
            float skillDamage = Config.uniqueEffects.hiveheart.damage;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker instanceof Player && !(player = (Player)attacker).getCooldowns().isOnCooldown(stack.getItem()) && (beeEntity = (SimplySwordsBeeEntity)((EntityType)EntityRegistry.SIMPLYBEEENTITY.get()).spawn(serverWorld, attacker.blockPosition().above(4).relative(attacker.getMotionDirection(), 3), MobSpawnType.MOB_SUMMONED)) != null && target != null) {
                beeEntity.setTarget(target);
                beeEntity.setPersistentAngerTarget(target.getUUID());
                beeEntity.setRemainingPersistentAngerTime(200);
                beeEntity.isAngryAt(target);
                beeEntity.setInvulnerable(true);
                beeEntity.setOwner(attacker);
                double attackDamage = 1.0 + (double)skillDamage * HelperMethods.getEntityAttackDamage(attacker);
                AttributeInstance attackAttribute = beeEntity.getAttribute(Attributes.ATTACK_DAMAGE);
                if (attackAttribute != null) {
                    attackAttribute.setBaseValue(attackDamage);
                }
                player.getCooldowns().addCooldown(stack.getItem(), skillCooldown);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        int regenDuration = Config.uniqueEffects.hiveheart.duration;
        int skillCooldown = Config.uniqueEffects.hiveheart.cooldown;
        HelperMethods.incrementStatusEffect((LivingEntity)user, (Holder<MobEffect>)MobEffects.REGENERATION, regenDuration, 1, 3);
        ItemStack stack = user.getItemInHand(hand);
        world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.SPELL_MISC_02.get(), user.getSoundSource(), 0.8f, 1.0f);
        user.getCooldowns().addCooldown(stack.getItem(), skillCooldown * 10);
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.FALLING_HONEY, (ParticleOptions)ParticleTypes.LANDING_HONEY, (ParticleOptions)ParticleTypes.LANDING_HONEY, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip6", (Object[])new Object[]{Config.uniqueEffects.hiveheart.cooldown / 20}).setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip9").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.hiveheartsworditem.tooltip10").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=0)
        public int duration;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.HIVEHEART.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 60;
            this.damage = 1.1f;
            this.duration = 450;
        }
    }
}

