/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ChanceDurationSettings;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class EmberIreSwordItem
extends UniqueSwordItem {
    private static SimpleParticleType particleWalk = ParticleTypes.FALLING_LAVA;
    private static SimpleParticleType particleSprint = ParticleTypes.FALLING_LAVA;
    private static SimpleParticleType particlePassive = ParticleTypes.SMOKE;

    public EmberIreSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide && remainingUseTicks % 10 == 0 && remainingUseTicks < this.getUseDuration(stack, user) - 5) {
            world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_RECHARGE.get(), user.getSoundSource(), 0.2f, 1.1f - (float)remainingUseTicks * 0.001f);
            if (remainingUseTicks < 20) {
                this.releaseUsing(stack, world, user, remainingUseTicks);
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.isClientSide && user.getItemBySlot(EquipmentSlot.MAINHAND) == stack) {
            Optional<LivingEntity> targetEntityReturn = HelperMethods.findClosestTarget(user, 18.0, 3.0);
            double damageAmount = HelperMethods.getEntityAttackDamage(user) * 0.3;
            if (targetEntityReturn.isPresent() && HelperMethods.checkFriendlyFire(targetEntityReturn.get(), user)) {
                LivingEntity targetEntity = targetEntityReturn.get();
                SoundEvent soundSelect = (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get();
                int particleCount = 20;
                HelperMethods.spawnWaistHeightParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.SMOKE, (Entity)user, (Entity)targetEntity, particleCount);
                HelperMethods.spawnWaistHeightParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.POOF, (Entity)user, (Entity)targetEntity, particleCount);
                HelperMethods.spawnWaistHeightParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.ASH, (Entity)user, (Entity)targetEntity, particleCount);
                world.playSound(null, user.blockPosition(), soundSelect, user.getSoundSource(), 0.4f, 1.5f);
                DamageSource damageSource = user.damageSources().generic();
                if (user instanceof Player) {
                    Player player = (Player)user;
                    damageSource = user.damageSources().playerAttack(player);
                    player.getCooldowns().addCooldown(stack.getItem(), 10);
                }
                float minAdditionalDamage = 0.0f;
                float maxAdditionalDamage = (float)(HelperMethods.getEntityAttackDamage(user) * 3.0);
                float chargeRatio = 1.0f - (float)remainingUseTicks / (float)this.getUseDuration(stack, user);
                float additionalDamage = 0.0f + (maxAdditionalDamage - 0.0f) * chargeRatio;
                float finalDamage = (float)damageAmount + additionalDamage;
                targetEntity.invulnerableTime = 0;
                targetEntity.hurt(damageSource, finalDamage);
                world.playSound(null, targetEntity.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), user.getSoundSource(), 0.4f, 1.1f);
                HelperMethods.spawnOrbitParticles((ServerLevel)world, targetEntity.position(), (ParticleOptions)ParticleTypes.EXPLOSION, 1.0, 1);
                HelperMethods.spawnOrbitParticles((ServerLevel)world, targetEntity.position(), (ParticleOptions)ParticleTypes.POOF, 1.0, 20);
                user.setDeltaMovement(user.getLookAngle().reverse().scale(1.1));
                user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
                user.hurtMarked = true;
                int hitChance = Config.uniqueEffects.emberblade.chance;
                int duration = Config.uniqueEffects.emberblade.duration;
                if (user.getRandom().nextInt((int)(250.0f - chargeRatio * 100.0f)) <= hitChance) {
                    user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, duration, 0), (Entity)user);
                    user.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, duration, 1), (Entity)user);
                    user.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, duration, 0), (Entity)user);
                    world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_01.get(), user.getSoundSource(), 0.5f, 2.0f);
                    particlePassive = ParticleTypes.LAVA;
                    particleWalk = ParticleTypes.CAMPFIRE_COSY_SMOKE;
                    particleSprint = ParticleTypes.CAMPFIRE_COSY_SMOKE;
                }
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 80;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).hasEffect(MobEffects.DAMAGE_BOOST) && !player.isOnFire()) {
            particlePassive = ParticleTypes.SMOKE;
            particleWalk = ParticleTypes.FALLING_LAVA;
            particleSprint = ParticleTypes.FALLING_LAVA;
        }
        int stepMod = 7 - (int)(world.getGameTime() % 7L);
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)particleWalk, (ParticleOptions)particleSprint, (ParticleOptions)particlePassive, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclickheld").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip9").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip10").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.emberiresworditem.tooltip11").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    @Translation(prefix="", negate=true)
    public static class EffectSettings
    extends ChanceDurationSettings {
        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.EMBERBLADE.get();
            super(30, 150, new ItemStackTooltipAppender(supplierArray));
        }
    }
}

