/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class MagislamEffect
extends OrbitingEffect {
    public MagislamEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.ENCHANT);
    }

    @Override
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int ability_timer = Objects.requireNonNull(player.getEffect(EffectRegistry.getReference(EffectRegistry.MAGISLAM))).getDuration();
            double radius = Config.uniqueEffects.magispear.radius;
            double leapVelocity = 1.5;
            double height = 0.9;
            double descentVelocity = 1.0;
            double damage_multiplier = Config.uniqueEffects.magispear.damageModifier;
            double damage = HelperMethods.getEntityAttackDamage(livingEntity) * damage_multiplier;
            if (ability_timer >= 60) {
                player.setDeltaMovement(livingEntity.getLookAngle().scale(leapVelocity));
                player.setDeltaMovement(livingEntity.getDeltaMovement().x, height, livingEntity.getDeltaMovement().z);
                player.hurtMarked = true;
            } else if (ability_timer <= 50) {
                player.setDeltaMovement(livingEntity.getDeltaMovement().x, -descentVelocity, livingEntity.getDeltaMovement().z);
                player.hurtMarked = true;
                if (player.onGround()) {
                    AABB box = HelperMethods.createBox((Entity)player, radius);
                    for (Entity entities : livingEntity.level().getEntities((Entity)livingEntity, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                        LivingEntity le;
                        if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (LivingEntity)player)) continue;
                        le.setDeltaMovement((le.getX() - player.getX()) / 4.0, (le.getY() - player.getY()) / 4.0, (le.getZ() - player.getZ()) / 4.0);
                        le.hurt(player.damageSources().playerAttack(player), (float)damage);
                    }
                    HelperMethods.spawnOrbitParticles((ServerLevel)player.level(), player.position(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, 2.0, 8);
                    HelperMethods.spawnOrbitParticles((ServerLevel)player.level(), player.position(), (ParticleOptions)ParticleTypes.EXPLOSION, 1.0, 3);
                    player.level().playSound(null, (Entity)player, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.PLAYERS, 0.9f, 1.1f);
                    player.removeEffect(EffectRegistry.getReference(EffectRegistry.MAGISLAM));
                    player.removeEffect(EffectRegistry.getReference(EffectRegistry.RESILIENCE));
                }
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    @Override
    public void removeAttributeModifiers(AttributeMap attributes) {
        super.removeAttributeModifiers(attributes);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

