/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class HighOrbitingEffect
extends MobEffect {
    protected ParticleOptions particleType1 = null;
    protected ParticleOptions particleType2 = null;
    protected ParticleOptions particleType3 = null;
    protected ParticleOptions particleType4 = null;
    protected ParticleOptions particleType5 = null;
    protected float yOffset = 2.0f;
    protected float width = 2.0f;
    private double currentAngle = 0.0;

    public HighOrbitingEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide) {
            ServerLevel serverWorld = (ServerLevel)livingEntity.level();
            Vec3 center = livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() + this.yOffset), 0.0);
            double speed = 0.39269908169872414;
            double radius = this.width;
            int particleCount = (int)(5.0f + this.width);
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particleCount;
                double x = center.x + radius * Math.cos(angle + this.currentAngle);
                double z = center.z + radius * Math.sin(angle + this.currentAngle);
                double y = center.y;
                this.spawnParticles(serverWorld, x, y, z);
            }
            this.currentAngle += speed;
            if (this.currentAngle >= Math.PI * 2) {
                this.currentAngle -= Math.PI * 2;
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    private void spawnParticles(ServerLevel serverWorld, double x, double y, double z) {
        if (this.particleType1 != null) {
            serverWorld.sendParticles(this.particleType1, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.particleType2 != null) {
            serverWorld.sendParticles(this.particleType2, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.particleType3 != null) {
            serverWorld.sendParticles(this.particleType3, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.particleType4 != null) {
            serverWorld.sendParticles(this.particleType4, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.particleType5 != null) {
            serverWorld.sendParticles(this.particleType5, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void setParticleType1(ParticleOptions particleType) {
        this.particleType1 = particleType;
    }

    protected void setParticleType2(ParticleOptions particleType) {
        this.particleType2 = particleType;
    }

    protected void setParticleType3(ParticleOptions particleType) {
        this.particleType3 = particleType;
    }

    protected void setParticleType4(ParticleOptions particleType) {
        this.particleType4 = particleType;
    }

    protected void setParticleType5(ParticleOptions particleType) {
        this.particleType5 = particleType;
    }

    protected void setyOffset(float yOffset) {
        this.yOffset = yOffset;
    }

    protected void setWidth(float width) {
        this.width = width;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

