/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.vivecraftcompat.VRMode;
import com.tom.vivecraftcompat.access.MC;
import com.tom.vivecraftcompat.events.VRBindingsEvent;
import com.tom.vivecraftcompat.events.VRUpdateControllersEvent;
import com.tom.vivecraftcompat.overlay.HudOverlayScreen;
import com.tom.vivecraftcompat.overlay.OverlayLock;
import com.tom.vivecraftcompat.overlay.VRInteractableScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRTextureTarget;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;
import org.vivecraft.client_vr.render.helpers.RenderHelper;

public class OverlayManager {
    public static Minecraft minecraft = Minecraft.getInstance();
    public static ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    private static List<Layer> screens = new ArrayList<Layer>();
    private static boolean overlayRendering;

    public static void resizeBuffers() {
        screens.forEach(Layer::resize);
    }

    public static void drawLayers(DeltaTracker.Timer partial) {
        if (!VRMode.isVR() || screens.isEmpty()) {
            return;
        }
        MC mc = (MC)minecraft;
        RenderTarget bak = minecraft.getMainRenderTarget();
        overlayRendering = true;
        for (Layer layer : screens) {
            layer.initialize();
            if (layer.framebuffer == null) continue;
            mc.mc$setMainRenderTarget(layer.getFramebuffer());
            layer.framebuffer.clear(Minecraft.ON_OSX);
            layer.framebuffer.bindWrite(true);
            GuiGraphics guiGraphics = new GuiGraphics(minecraft, minecraft.renderBuffers().bufferSource());
            RenderHelper.drawScreen((GuiGraphics)guiGraphics, (DeltaTracker)partial, (Screen)layer.screen, (boolean)true);
            guiGraphics.flush();
        }
        overlayRendering = false;
        mc.mc$setMainRenderTarget(bak);
        bak.bindWrite(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void overlayPre(RenderGuiLayerEvent.Pre event) {
        if (overlayRendering || !VRMode.isVR()) {
            return;
        }
        ResourceLocation rl = event.getName();
        if (OverlayManager.isOverlayDetached(rl)) {
            event.setCanceled(true);
        }
    }

    public static void populateListeners() {
        OverlayManager.registerListener(OverlayManager.minecraft.options.keyAttack, 0);
        OverlayManager.registerListener(OverlayManager.minecraft.options.keyUse, 1);
        OverlayManager.registerListener(GuiHandler.KEY_LEFT_CLICK, 0);
        OverlayManager.registerListener(GuiHandler.KEY_RIGHT_CLICK, 1);
    }

    private static void registerListener(KeyMapping map, final int kb) {
        MCVR.get().getInputAction(map).registerListener(new VRInputAction.KeyListener(){

            public boolean onUnpressed(ControllerType var1) {
                return OverlayManager.interact(kb, false);
            }

            public boolean onPressed(ControllerType var1) {
                return OverlayManager.interact(kb, true);
            }

            public int getPriority() {
                return 0;
            }
        });
    }

    public static boolean isOverlayDetached(ResourceLocation rl) {
        return VRMode.isVR() && screens.stream().anyMatch(h -> {
            HudOverlayScreen s;
            Screen patt0$temp = h.screen;
            return patt0$temp instanceof HudOverlayScreen && (s = (HudOverlayScreen)patt0$temp).isEnabled() && s.overlays.contains(rl);
        });
    }

    public static void addLayer(Layer layer) {
        screens.add(layer);
    }

    public static void forEachLayer(Consumer<Layer> renderLayer) {
        if (screens.isEmpty()) {
            return;
        }
        new ArrayList<Layer>(screens).forEach(renderLayer);
    }

    public static void renderLayers(Consumer<Layer> renderLayer) {
        if (!VRMode.isVR()) {
            return;
        }
        OverlayManager.forEachLayer(l -> {
            if (!l.ready()) {
                return;
            }
            float gs = GuiHandler.GUI_SCALE;
            GuiHandler.GUI_SCALE = gs * l.scale;
            renderLayer.accept((Layer)l);
            GuiHandler.GUI_SCALE = gs;
        });
    }

    @SubscribeEvent
    public static void tick(ClientTickEvent.Post event) {
        if (!VRMode.isVR()) {
            return;
        }
        OverlayManager.forEachLayer(l -> l.screen.tick());
    }

    @SubscribeEvent
    public static void processGui(VRUpdateControllersEvent event) {
        OverlayManager.forEachLayer(s -> {
            Screen patt0$temp = s.screen;
            if (patt0$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt0$temp;
                i.processGui();
            }
            s.updateMovingLayer();
        });
    }

    @SubscribeEvent
    public static void processBindings(VRBindingsEvent event) {
        for (Layer layer : screens) {
            if (layer.startControllerPose == null || !VivecraftVRMod.INSTANCE.keyMenuButton.consumeClick()) continue;
            layer.stopMovingLayer();
        }
        if (KeyboardHandler.SHOWING) {
            return;
        }
        OverlayManager.forEachLayer(s -> {
            Screen patt0$temp = s.screen;
            if (patt0$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt0$temp;
                i.processBindings();
            }
        });
    }

    public static boolean isUsingController() {
        return screens.stream().anyMatch(l -> {
            VRInteractableScreen i;
            Screen patt0$temp = l.screen;
            return patt0$temp instanceof VRInteractableScreen && (i = (VRInteractableScreen)patt0$temp).isUsingController();
        });
    }

    public static Optional<Layer> findLayer(Screen s) {
        return screens.stream().filter(l -> l.screen == s).findFirst();
    }

    public static boolean type(char character) {
        boolean[] found = new boolean[]{false};
        OverlayManager.forEachLayer(s -> {
            if (found[0]) {
                return;
            }
            Screen patt0$temp = s.screen;
            if (patt0$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt0$temp;
                found[0] = i.type(character);
            }
        });
        return found[0];
    }

    public static boolean key(int key) {
        boolean[] found = new boolean[]{false};
        OverlayManager.forEachLayer(s -> {
            if (found[0]) {
                return;
            }
            Screen patt0$temp = s.screen;
            if (patt0$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt0$temp;
                found[0] = i.key(key);
            }
        });
        return found[0];
    }

    public static boolean interact(int key, boolean press) {
        boolean[] found = new boolean[]{false};
        OverlayManager.forEachLayer(s -> {
            if (found[0]) {
                return;
            }
            Screen patt0$temp = s.screen;
            if (patt0$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt0$temp;
                found[0] = i.interact(key, press);
            }
        });
        return found[0];
    }

    public static class Layer {
        private RenderTarget framebuffer = null;
        private Screen screen;
        private Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
        private Matrix4f rotation = new Matrix4f();
        private OverlayLock lock = OverlayLock.FLOAT;
        private float scale = 1.0f;
        private int startController;
        private VRData.VRDevicePose startControllerPose;
        private float startDragPosX;
        private float startDragPosY;
        private float startDragPosZ;
        private Matrix4f startDragRot;
        private boolean moved;
        private OverlayLock preMoveLock;

        public Layer(Screen screen) {
            this.screen = screen;
        }

        public Layer(Function<Layer, Screen> screen) {
            this.screen = screen.apply(this);
        }

        public void resize() {
            if (VRMode.isVR()) {
                if (this.framebuffer == null) {
                    this.framebuffer = new VRTextureTarget("VCC Overlay: " + this.screen.getClass().getName(), GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, true, -1, true, false, false);
                } else {
                    this.framebuffer.resize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, Minecraft.ON_OSX);
                }
                int l2 = minecraft.getWindow().getGuiScaledWidth();
                int j3 = minecraft.getWindow().getGuiScaledHeight();
                this.screen.init(minecraft, l2, j3);
            }
        }

        public RenderTarget getFramebuffer() {
            return this.framebuffer;
        }

        public Vector3f getPos() {
            if (this.startControllerPose != null) {
                return this.pos;
            }
            OverlayLock.LockedPosition pose = this.lock.getLocked();
            if (pose == null) {
                return this.pos;
            }
            Vec3 pp = pose.getPosition();
            Vector4f r = pose.getMatrix().transform(new Vector4f((Vector3fc)this.pos, 1.0f)).add((Vector4fc)new Vector4f((float)pp.x, (float)pp.y, (float)pp.z, 0.0f));
            return new Vector3f(r.x / r.w, r.y / r.w, r.z / r.w);
        }

        public Matrix4f getRotation() {
            if (this.startControllerPose != null) {
                return this.rotation;
            }
            OverlayLock.LockedPosition pose = this.lock.getLocked();
            if (pose == null) {
                return this.rotation;
            }
            return pose.getMatrix().mul((Matrix4fc)this.rotation, new Matrix4f());
        }

        public void spawnOverlay(ControllerType controller) {
            VRData.VRDevicePose vrdata$vrdevicepose = OverlayManager.dh.vrPlayer.vrdata_room_pre.hmd;
            float f = 2.0f;
            int i = 0;
            if (controller == ControllerType.LEFT) {
                i = 1;
            }
            vrdata$vrdevicepose = OverlayManager.dh.vrPlayer.vrdata_room_pre.getController(i);
            f = 1.2f;
            Vector3f vec3 = vrdata$vrdevicepose.getPositionF();
            Vector3f vec31 = new Vector3f(0.0f, 0.0f, -f);
            Vector3f vec32 = vrdata$vrdevicepose.getCustomVector((Vector3fc)vec31);
            this.pos = new Vector3f(vec32.x / 2.0f + vec3.x, vec32.y / 2.0f + vec3.y, vec32.z / 2.0f + vec3.z);
            Vector3f vector3 = new Vector3f();
            vector3.x = this.pos.x - vec3.x;
            vector3.y = this.pos.y - vec3.y;
            vector3.z = this.pos.z - vec3.z;
            float f1 = (float)Math.asin(vector3.y / vector3.length());
            float f2 = (float)(3.1415927410125732 + Math.atan2(vector3.x, vector3.z));
            this.rotation = new Matrix4f().rotationY(f2);
            Matrix4f matrix4f = new Matrix4f().rotationX(f1);
            this.rotation.mul((Matrix4fc)matrix4f);
        }

        public void remove() {
            if (this.framebuffer != null) {
                RenderTarget f = this.framebuffer;
                this.framebuffer = null;
                RenderSystem.recordRenderCall(() -> f.destroyBuffers());
            }
            screens.remove(this);
        }

        public void setPos(Vector3f pos) {
            this.pos = pos;
        }

        public void setPos(Vector4f pos) {
            this.pos = new Vector3f(pos.x, pos.y, pos.z);
        }

        public void setRotation(Matrix4f rotation) {
            this.rotation = rotation;
        }

        public void startMovingLayer(int controller) {
            this.preMoveLock = this.lock;
            this.setLock(OverlayLock.FLOAT);
            this.startController = controller;
            this.startControllerPose = OverlayManager.dh.vrPlayer.vrdata_room_pre.getController(controller);
            this.startDragPosX = this.pos.x;
            this.startDragPosY = this.pos.y;
            this.startDragPosZ = this.pos.z;
            this.startDragRot = new Matrix4f((Matrix4fc)this.rotation);
            this.moved = false;
        }

        public void updateMovingLayer() {
            if (this.startControllerPose != null) {
                VRData.VRDevicePose vrdata$vrdevicepose = OverlayManager.dh.vrPlayer.vrdata_room_pre.getController(this.startController);
                Vec3 vec3 = this.startControllerPose.getPosition();
                Vec3 vec31 = vrdata$vrdevicepose.getPosition().subtract(vec3);
                Matrix4f matrix4f = vrdata$vrdevicepose.getMatrix().mul((Matrix4fc)this.startControllerPose.getMatrix().invert(new Matrix4f()), new Matrix4f());
                Vector3f vector3 = new Vector3f(this.startDragPosX - (float)vec3.x, this.startDragPosY - (float)vec3.y, this.startDragPosZ - (float)vec3.z);
                Vector4f vector31 = matrix4f.transform(new Vector4f((Vector3fc)vector3, 1.0f));
                float px = this.startDragPosX + (float)vec31.x + (vector31.x - vector3.x);
                float py = this.startDragPosY + (float)vec31.y + (vector31.y - vector3.y);
                float pz = this.startDragPosZ + (float)vec31.z + (vector31.z - vector3.z);
                this.setPos(new Vector3f(px, py, pz));
                this.setRotation(matrix4f.mul((Matrix4fc)this.startDragRot));
                this.moved = true;
            }
        }

        public void stopMovingLayer() {
            this.startControllerPose = null;
            if (this.moved) {
                this.setLock(this.preMoveLock);
                this.moved = false;
            }
        }

        public boolean isMoving() {
            return this.startControllerPose != null;
        }

        public Screen getScreen() {
            return this.screen;
        }

        public void setLock(OverlayLock lock) {
            this.setPos(this.getPos());
            this.setRotation(this.getRotation());
            this.lock = lock;
            OverlayLock.LockedPosition pose = lock.getLocked();
            if (pose != null) {
                Matrix4f mat = pose.getMatrix().invert(new Matrix4f()).mul((Matrix4fc)this.rotation);
                this.setPos(pose.getMatrix().invert(new Matrix4f()).transform(new Vector4f((Vector3fc)new Vector3f((Vector3fc)this.pos).sub((Vector3fc)pose.getPositionF()), 1.0f)));
                this.setRotation(mat);
            }
        }

        public OverlayLock getLock() {
            return this.lock;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        public float getScale() {
            return this.scale;
        }

        public Vector3f getPosRaw() {
            return this.pos;
        }

        public Matrix4f getRotationRaw() {
            return this.rotation;
        }

        public void setLockDirect(OverlayLock lock) {
            this.lock = lock;
        }

        public void initialize() {
            if (this.framebuffer == null) {
                this.resize();
            }
        }

        public boolean ready() {
            return this.framebuffer != null;
        }

        public void addPos(Vector3f d) {
            this.pos.x += d.x * 0.025f;
            this.pos.y += d.y * 0.025f;
            this.pos.z += d.z * 0.025f;
        }

        public void addRotation(Vector3f d) {
            Matrix4f rotationMatrix = this.getRotationRaw();
            Quaternionf quaternion = new Quaternionf();
            rotationMatrix.getUnnormalizedRotation(quaternion);
            quaternion.rotateAxis((float)Math.toRadians(10.0), (Vector3fc)d);
            Matrix4f mat = new Matrix4f().rotate((Quaternionfc)quaternion);
            this.setRotation(mat);
        }
    }
}

