/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.create;

import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorTargetFloorPacket;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsScreen;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;

public class ElevatorControlsVRScreen
extends ValueSettingsScreen {
    private ContraptionControlsMovement.ElevatorFloorSelection selection;
    private ElevatorContraption elevator;
    private MovementContext ctx;

    public ElevatorControlsVRScreen(ElevatorContraption elevator, ContraptionControlsMovement.ElevatorFloorSelection selection, MovementContext ctx) {
        super(null, ElevatorControlsVRScreen.makeBoard(elevator), new ValueSettingsBehaviour.ValueSettings(elevator.namesList.size() - selection.currentIndex - 1, 0), v -> {}, 0);
        this.selection = selection;
        this.elevator = elevator;
        this.ctx = ctx;
    }

    private static ValueSettingsBoard makeBoard(ElevatorContraption ec) {
        List rows = ec.namesList.stream().map(e -> Component.literal((String)((String)((Couple)e.getSecond()).getFirst()))).collect(Collectors.toList());
        Collections.reverse(rows);
        ValueSettingsFormatter format = new ValueSettingsFormatter(s -> {
            int i = Mth.clamp((int)(ec.namesList.size() - s.row() - 1), (int)0, (int)(ec.namesList.size() - 1));
            IntAttached entry = (IntAttached)ec.namesList.get(i);
            return Component.literal((String)((String)((Couple)entry.getSecond()).getSecond()));
        });
        return new ValueSettingsBoard((Component)Component.translatable((String)"vivecraftcompat.gui.create.elevator.floor_select"), 0, 1, rows, format);
    }

    protected void saveAndClose(double pMouseX, double pMouseY) {
        ValueSettingsBehaviour.ValueSettings closest = this.getClosestCoordinate((int)pMouseX, (int)pMouseY);
        this.selection.currentIndex = Mth.clamp((int)(this.elevator.namesList.size() - closest.row() - 1), (int)0, (int)(this.elevator.namesList.size() - 1));
        ContraptionControlsMovement.tickFloorSelection((ContraptionControlsMovement.ElevatorFloorSelection)this.selection, (ElevatorContraption)this.elevator);
        if (this.selection.currentTargetY == this.elevator.clientYTarget) {
            return;
        }
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ElevatorTargetFloorPacket(this.elevator.entity, this.selection.currentTargetY));
        Object v = this.elevator.presentBlockEntities.get(this.ctx.localPos);
        if (v instanceof ContraptionControlsBlockEntity) {
            ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)v;
            cbe.pressButton();
        }
        this.onClose();
    }
}

