/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.override;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.level.GameRules;

public final class GameRuleValueOverrides {
    private GameRuleValueOverrides() {
    }

    public static void setValue(GameRules.Key<GameRules.BooleanValue> key, boolean value) {
        GameRuleValueOverrides.setValue(key, booleanValue -> booleanValue.set(value, null));
    }

    public static void setValue(GameRules.Key<GameRules.IntegerValue> key, int value) {
        GameRuleValueOverrides.setValue(key, integerValue -> integerValue.set(value, null));
    }

    public static <T extends GameRules.Value<T>> void setValue(GameRules.Key<T> key, Consumer<T> valueSetter) {
        GameRules.Type type = (GameRules.Type)GameRules.GAME_RULE_TYPES.get(key);
        Function originalConstructor = type.constructor;
        type.constructor = factoryType -> {
            GameRules.Value ruleValue = (GameRules.Value)originalConstructor.apply(factoryType);
            valueSetter.accept(ruleValue);
            return ruleValue;
        };
    }
}

