/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network.to_server;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorLogicAdapter;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition, double extra) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketGeneratorsGuiInteract> TYPE = new CustomPacketPayload.Type(MekanismGenerators.rl("gui_interact"));
    public static final StreamCodec<ByteBuf, PacketGeneratorsGuiInteract> STREAM_CODEC = StreamCodec.composite(GeneratorsGuiInteraction.STREAM_CODEC, PacketGeneratorsGuiInteract::interaction, (StreamCodec)BlockPos.STREAM_CODEC, PacketGeneratorsGuiInteract::tilePosition, (StreamCodec)ByteBufCodecs.DOUBLE, PacketGeneratorsGuiInteract::extra, PacketGeneratorsGuiInteract::new);

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.getBlockPos());
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockEntity tile, double extra) {
        this(interaction, tile.getBlockPos(), extra);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0.0);
    }

    @NotNull
    public CustomPacketPayload.Type<PacketGeneratorsGuiInteract> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), (BlockPos)this.tilePosition);
        if (tile != null) {
            this.interaction.consume(tile, player, this.extra);
        }
    }

    public static enum GeneratorsGuiInteraction {
        INJECTION_RATE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFusionReactorBlock) {
                TileEntityFusionReactorBlock reactorBlock = (TileEntityFusionReactorBlock)((Object)tile);
                reactorBlock.setInjectionRateFromPacket((int)Math.round(extra));
            } else if (tile instanceof TileEntityFissionReactorCasing) {
                TileEntityFissionReactorCasing reactorCasing = (TileEntityFissionReactorCasing)((Object)tile);
                reactorCasing.setRateLimitFromPacket((double)extra);
            }
        })),
        LOGIC_TYPE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFissionReactorLogicAdapter) {
                TileEntityFissionReactorLogicAdapter logicAdapter = (TileEntityFissionReactorLogicAdapter)tile;
                logicAdapter.setLogicTypeFromPacket(TileEntityFissionReactorLogicAdapter.FissionReactorLogic.BY_ID.apply((int)Math.round(extra)));
            } else if (tile instanceof TileEntityFusionReactorLogicAdapter) {
                TileEntityFusionReactorLogicAdapter logicAdapter = (TileEntityFusionReactorLogicAdapter)tile;
                logicAdapter.setLogicTypeFromPacket(TileEntityFusionReactorLogicAdapter.FusionReactorLogic.BY_ID.apply((int)Math.round(extra)));
            }
        })),
        FISSION_ACTIVE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFissionReactorCasing) {
                TileEntityFissionReactorCasing reactorCasing = (TileEntityFissionReactorCasing)((Object)tile);
                reactorCasing.setReactorActive(Math.round(extra) == 1L);
            }
        }));

        public static final IntFunction<GeneratorsGuiInteraction> BY_ID;
        public static final StreamCodec<ByteBuf, GeneratorsGuiInteraction> STREAM_CODEC;
        private final TriConsumer<TileEntityMekanism, Player, Double> consumerForTile;

        private GeneratorsGuiInteraction(TriConsumer<TileEntityMekanism, Player, Double> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, double extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GeneratorsGuiInteraction.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

