/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.data;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packager.PackagerBlock;
import com.simibubi.create.foundation.data.SpecialBlockStateGen;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.VibrantPackagerBlock;
import net.zlt.create_vibrant_vaults.duck.ModelBuilderMixinDuck;

public class VibrantPackagerBlockStateGenerator
extends SpecialBlockStateGen {
    protected int getXRotation(BlockState state) {
        return 0;
    }

    protected int getYRotation(BlockState state) {
        return this.horizontalAngle((Direction)state.getValue((Property)PackagerBlock.FACING));
    }

    public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
        Block block = state.getBlock();
        if (!(block instanceof VibrantPackagerBlock)) {
            throw new IllegalArgumentException("Invalid vibrant packager");
        }
        VibrantPackagerBlock vibrantPackager = (VibrantPackagerBlock)block;
        String colorId = vibrantPackager.color.asId();
        boolean linked = state.getOptionalValue((Property)PackagerBlock.LINKED).orElse(false);
        boolean powered = (Boolean)state.getValue((Property)PackagerBlock.POWERED);
        return ((Direction)state.getValue((Property)PackagerBlock.FACING)).getAxis() == Direction.Axis.Y ? this.getVerticalModel(ctx, prov, linked, powered, colorId) : this.getHorizontalModel(ctx, prov, linked, powered, colorId);
    }

    private <T extends Block> ModelFile getHorizontalModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, boolean linked, boolean powered, String colorId) {
        if (linked) {
            return ((BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder("block/" + ctx.getName() + "/block_linked")).parent((ModelFile)new ModelFile.UncheckedModelFile(CreateVibrantVaults.asResource("block/" + ctx.getName() + "/block")))).texture("2", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_horizontal_linked"));
        }
        if (powered) {
            return ((BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder("block/" + ctx.getName() + "/block_powered")).parent((ModelFile)new ModelFile.UncheckedModelFile(CreateVibrantVaults.asResource("block/" + ctx.getName() + "/block")))).texture("2", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_horizontal_powered"));
        }
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder("block/" + ctx.getName() + "/block")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/packager/block")));
        ((ModelBuilderMixinDuck)builder).createVibrantVaults$uncheckedTexture("0", Create.asResource((String)"block/packager_frame"));
        ((BlockModelBuilder)((BlockModelBuilder)builder.texture("1", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_details"))).texture("2", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_horizontal_unpowered"))).texture("particle", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_particle"));
        return builder;
    }

    private <T extends Block> ModelFile getVerticalModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, boolean linked, boolean powered, String colorId) {
        if (linked) {
            return ((BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder("block/" + ctx.getName() + "/block_vertical_linked")).parent((ModelFile)new ModelFile.UncheckedModelFile(CreateVibrantVaults.asResource("block/" + ctx.getName() + "/block_vertical")))).texture("5", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_vertical_linked"));
        }
        if (powered) {
            return ((BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder("block/" + ctx.getName() + "/block_vertical_powered")).parent((ModelFile)new ModelFile.UncheckedModelFile(CreateVibrantVaults.asResource("block/" + ctx.getName() + "/block_vertical")))).texture("5", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_vertical_powered"));
        }
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)prov.models().getBuilder("block/" + ctx.getName() + "/block_vertical")).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/packager/block_vertical")));
        ((ModelBuilderMixinDuck)builder).createVibrantVaults$uncheckedTexture("0", Create.asResource((String)"block/packager_frame"));
        ((BlockModelBuilder)((BlockModelBuilder)builder.texture("1", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_details"))).texture("5", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_vertical_unpowered"))).texture("particle", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_particle"));
        return builder;
    }
}

