/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.zlt.create_vibrant_vaults.block.ItemVaultConnectivityHelper;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import net.zlt.create_vibrant_vaults.block.VibrantVaultBlock;

public class VerticalVaultBlock
extends VibrantVaultBlock {
    public VerticalVaultBlock(ModBlocks.VibrantVaultType type, ModBlocks.VibrantVaultColor color, BlockBehaviour.Properties properties) {
        super(type, color, properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LARGE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.defaultBlockState();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getClickedFace().getAxis().isHorizontal()) {
            BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
            if (be instanceof ItemVaultBlockEntity) {
                ItemVaultBlockEntity vault = (ItemVaultBlockEntity)be;
                ItemVaultConnectivityHelper.splitItemVaultMulti(vault);
                vault.removeController(true);
            }
            state = (BlockState)state.setValue((Property)LARGE, (Comparable)Boolean.valueOf(false));
        }
        Level world = context.getLevel();
        BlockState rotated = this.getRotatedBlockState(state, context.getClickedFace());
        if (!rotated.canSurvive((LevelReader)world, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched(rotated, context));
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof GeneratingKineticBlockEntity) {
            GeneratingKineticBlockEntity be = (GeneratingKineticBlockEntity)blockEntity;
            be.reActivateSource = true;
        }
        if (world.getBlockState(context.getClickedPos()) != state) {
            IWrenchable.playRotateSound((Level)world, (BlockPos)context.getClickedPos());
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return state;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.getAxis().isHorizontal()) {
            return (BlockState)this.getHorizontal().defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)(targetedFace.getAxis() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return originalState;
    }

    public Block getHorizontal() {
        return this.type == ModBlocks.VibrantVaultType.ITEM_VAULT && this.color == ModBlocks.VibrantVaultColor.BASE ? (Block)AllBlocks.ITEM_VAULT.get() : (Block)ModBlocks.getVibrantVault(this.type, this.color, false).get();
    }
}

