/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.screen.custom;

import com.simibubi.create.content.logistics.BigItemStack;
import com.xeli.createmetalogistics.LogisticsMod;
import com.xeli.createmetalogistics.ModBlocks;
import com.xeli.createmetalogistics.content.ticketcrate.PartialTicketItemEntry;
import com.xeli.createmetalogistics.content.ticketcrate.TicketCrateBlockEntity;
import com.xeli.createmetalogistics.network.AddressEditPacket;
import com.xeli.createmetalogistics.network.PartialTicketItemEntryEditPacket;
import com.xeli.createmetalogistics.screen.ModMenuTypes;
import com.xeli.createmetalogistics.util.PlayUiSoundKt;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 @2\u00020\u0001:\u0001@B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u001c\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u000e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+J\u001e\u0010,\u001a\u00020-2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/J0\u00101\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J(\u00108\u001a\u00020\"2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0018\u00109\u001a\u00020+2\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\u0003H\u0016J\u0010\u0010<\u001a\u00020-2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020\u0005H\u0002J\u0010\u0010?\u001a\u00020\"2\u0006\u0010>\u001a\u00020\u0005H\u0002R\u0011\u0010\u0006\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001a\u00a8\u0006A"}, d2={"Lcom/xeli/createmetalogistics/screen/custom/TicketCrateMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "inv", "Lnet/minecraft/world/entity/player/Inventory;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "extraData", "Lnet/minecraft/network/FriendlyByteBuf;", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/FriendlyByteBuf;)V", "Lcom/xeli/createmetalogistics/content/ticketcrate/TicketCrateBlockEntity;", "getBlockEntity", "()Lcom/xeli/createmetalogistics/content/ticketcrate/TicketCrateBlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "ghostSlotDescription", "Lnet/minecraft/network/chat/MutableComponent;", "getGhostSlotDescription", "()Lnet/minecraft/network/chat/MutableComponent;", "outputSlots", "", "Lnet/neoforged/neoforge/items/SlotItemHandler;", "getOutputSlots", "()Ljava/util/List;", "ghostInventory", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getGhostInventory", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "ghostSlots", "getGhostSlots", "editSlot", "", "slot", "entry", "Ljava/util/Optional;", "Lcom/xeli/createmetalogistics/content/ticketcrate/PartialTicketItemEntry;", "editAddress", "newAddress", "", "newItemStack", "Lnet/minecraft/world/item/ItemStack;", "scrollOnSlot", "", "scrollX", "", "scrollY", "performGhostAction", "slotId", "button", "clickType", "Lnet/minecraft/world/inventory/ClickType;", "player", "Lnet/minecraft/world/entity/player/Player;", "clicked", "quickMoveStack", "playerIn", "pIndex", "stillValid", "addPlayerInventory", "playerInventory", "addPlayerHotbar", "Companion", "createmetalogistics-1.21.1"})
public final class TicketCrateMenu
extends AbstractContainerMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TicketCrateBlockEntity blockEntity;
    @NotNull
    private final Level level;
    @NotNull
    private final MutableComponent ghostSlotDescription;
    @NotNull
    private final List<SlotItemHandler> outputSlots;
    @NotNull
    private final ItemStackHandler ghostInventory;
    @NotNull
    private final List<SlotItemHandler> ghostSlots;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 9 + PLAYER_INVENTORY_SLOT_COUNT;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 0 + VANILLA_SLOT_COUNT;
    private static final int TE_INVENTORY_SLOT_COUNT = 9;

    /*
     * WARNING - void declaration
     */
    public TicketCrateMenu(int containerId, @NotNull Inventory inv, @NotNull BlockEntity blockEntity) {
        SlotItemHandler slotItemHandler;
        int i;
        List list;
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        super((MenuType)ModMenuTypes.INSTANCE.getTICKET_CRATE_MENU().get(), containerId);
        this.blockEntity = (TicketCrateBlockEntity)blockEntity;
        Level level = inv.player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this.level = level;
        MutableComponent mutableComponent = Component.translatable((String)"menu.createmetalogistics.ticket_crate.input_slot");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        this.ghostSlotDescription = mutableComponent;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        List list2 = list = CollectionsKt.createListBuilder();
        TicketCrateMenu ticketCrateMenu = this;
        boolean bl = false;
        for (i = 0; i < 9; ++i) {
            void $this$outputSlots_u24lambda_u240;
            slotItemHandler = new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), i, 8 + 18 * i, 54);
            $this$outputSlots_u24lambda_u240.add(slotItemHandler);
            this.addSlot((Slot)slotItemHandler);
        }
        ticketCrateMenu.outputSlots = CollectionsKt.build((List)list);
        this.ghostInventory = new ItemStackHandler(9);
        List<Optional<PartialTicketItemEntry>> initialTicketList = this.blockEntity.getStoredTickets();
        for (int i2 = 0; i2 < 9; ++i2) {
            Optional<PartialTicketItemEntry> entry = initialTicketList.get(i2);
            ItemStack fakeItemStack = entry.isPresent() ? entry.get().getItem().stack : ItemStack.EMPTY;
            this.ghostInventory.setStackInSlot(i2, fakeItemStack);
        }
        List i2 = list = CollectionsKt.createListBuilder();
        ticketCrateMenu = this;
        boolean bl2 = false;
        for (i = 0; i < 9; ++i) {
            void $this$ghostSlots_u24lambda_u241;
            slotItemHandler = new SlotItemHandler((IItemHandler)this.ghostInventory, i, 8 + 18 * i, 18);
            $this$ghostSlots_u24lambda_u241.add(slotItemHandler);
            this.addSlot((Slot)slotItemHandler);
        }
        ticketCrateMenu.ghostSlots = CollectionsKt.build((List)list);
    }

    @NotNull
    public final TicketCrateBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public TicketCrateMenu(int containerId, @NotNull Inventory inv, @NotNull FriendlyByteBuf extraData) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        BlockEntity blockEntity = inv.player.level().getBlockEntity(extraData.readBlockPos());
        Intrinsics.checkNotNull((Object)blockEntity);
        this(containerId, inv, blockEntity);
    }

    @NotNull
    public final MutableComponent getGhostSlotDescription() {
        return this.ghostSlotDescription;
    }

    @NotNull
    public final List<SlotItemHandler> getOutputSlots() {
        return this.outputSlots;
    }

    @NotNull
    public final ItemStackHandler getGhostInventory() {
        return this.ghostInventory;
    }

    @NotNull
    public final List<SlotItemHandler> getGhostSlots() {
        return this.ghostSlots;
    }

    public final void editSlot(int slot, @NotNull Optional<PartialTicketItemEntry> entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        this.blockEntity.getStoredTickets().set(slot, entry);
        BlockPos blockPos = this.blockEntity.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        PacketDistributor.sendToServer((CustomPacketPayload)new PartialTicketItemEntryEditPacket(blockPos, slot, entry), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void editAddress(@NotNull String newAddress) {
        Intrinsics.checkNotNullParameter((Object)newAddress, (String)"newAddress");
        this.blockEntity.setDefaultAddress(newAddress);
        BlockPos blockPos = this.blockEntity.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        PacketDistributor.sendToServer((CustomPacketPayload)new AddressEditPacket(blockPos, newAddress), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void editSlot(int slot, @NotNull ItemStack newItemStack) {
        Optional<String> optional;
        Intrinsics.checkNotNullParameter((Object)newItemStack, (String)"newItemStack");
        if (newItemStack.isEmpty()) {
            Optional<PartialTicketItemEntry> optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
            this.editSlot(slot, optional2);
            return;
        }
        Optional<PartialTicketItemEntry> entry = this.blockEntity.getStoredTickets().get(slot);
        if (entry.isPresent()) {
            optional = entry.get().getPackageAddress();
        } else {
            Optional optional3 = Optional.empty();
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        }
        Optional<String> newAddress = optional;
        Optional<PartialTicketItemEntry> optional4 = Optional.of(new PartialTicketItemEntry(new BigItemStack(newItemStack.copyWithCount(1), newItemStack.getCount()), newAddress));
        Intrinsics.checkNotNullExpressionValue(optional4, (String)"of(...)");
        this.editSlot(slot, optional4);
    }

    public final boolean scrollOnSlot(@NotNull SlotItemHandler slot, double scrollX, double scrollY) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        int index = this.ghostSlots.indexOf(slot);
        Optional<PartialTicketItemEntry> entryOptional = this.blockEntity.getStoredTickets().get(index);
        boolean remove = scrollY < 0.0;
        int transfer = Mth.ceil((double)Math.abs(scrollY)) * (Screen.hasControlDown() ? 10 : 1);
        if (entryOptional.isPresent()) {
            PartialTicketItemEntry partialTicketItemEntry = entryOptional.get();
            Intrinsics.checkNotNullExpressionValue((Object)partialTicketItemEntry, (String)"get(...)");
            PartialTicketItemEntry entry = partialTicketItemEntry;
            BigItemStack item = entry.getItem();
            int minStackSize = 1;
            int maxStackSize = 999;
            BigItemStack newCount = new BigItemStack(item.stack, Math.max(minStackSize, Math.min(maxStackSize, remove ? item.count - transfer : item.count + transfer)));
            SoundEvent soundEvent = SoundEvents.WOOL_STEP;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"WOOL_STEP");
            PlayUiSoundKt.playUiSound(soundEvent, 0.75f, 1.2f);
            SoundEvent soundEvent2 = SoundEvents.BAMBOO_WOOD_STEP;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent2, (String)"BAMBOO_WOOD_STEP");
            PlayUiSoundKt.playUiSound(soundEvent2, 0.75f, 0.8f);
            PartialTicketItemEntry newEntry = PartialTicketItemEntry.copy$default(entry, newCount, null, 2, null);
            Optional<PartialTicketItemEntry> optional = Optional.of(newEntry);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            this.editSlot(index, optional);
            return true;
        }
        return false;
    }

    private final void performGhostAction(SlotItemHandler slot, int slotId, int button, ClickType clickType, Player player) {
        if (clickType == ClickType.THROW) {
            return;
        }
        ItemStack carriedStack = this.getCarried();
        int ghostSlotIndex = this.ghostSlots.indexOf(slot);
        if (clickType == ClickType.CLONE) {
            if (player.isCreative() && carriedStack.isEmpty()) {
                Optional<PartialTicketItemEntry> entry = this.blockEntity.getStoredTickets().get(ghostSlotIndex);
                ItemStack itemStack = (entry.isPresent() ? entry.get().getItem().stack : ItemStack.EMPTY).copy();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                ItemStack stackInSlot = itemStack;
                stackInSlot.setCount(((Number)stackInSlot.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64)).intValue());
                this.setCarried(stackInSlot);
                return;
            }
            return;
        }
        ItemStack insert = carriedStack.isEmpty() ? ItemStack.EMPTY : carriedStack.copy();
        slot.set(insert.copyWithCount(1));
        Intrinsics.checkNotNull((Object)insert);
        this.editSlot(ghostSlotIndex, insert);
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        for (SlotItemHandler slot : this.ghostSlots) {
            int newIndex = slot.getSlotIndex() + TE_INVENTORY_FIRST_SLOT_INDEX + 9;
            if (slotId != newIndex) continue;
            this.performGhostAction(slot, slotId, button, clickType, player);
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int pIndex) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Object object = this.slots.get(pIndex);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot sourceSlot = (Slot)object;
        if (!sourceSlot.hasItem()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 0 + VANILLA_SLOT_COUNT) {
            if (!this.moveItemStackTo(sourceStack, TE_INVENTORY_FIRST_SLOT_INDEX, TE_INVENTORY_FIRST_SLOT_INDEX + 9, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else if (pIndex < TE_INVENTORY_FIRST_SLOT_INDEX + 9) {
            if (!this.moveItemStackTo(sourceStack, 0, 0 + VANILLA_SLOT_COUNT, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else {
            LogisticsMod.Companion.getLOGGER().warn("Invalid slotIndex:" + pIndex);
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        Intrinsics.checkNotNull((Object)copyOfSourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)ModBlocks.INSTANCE.getTicketCrateBlock().get()));
    }

    private final void addPlayerInventory(Inventory playerInventory) {
        int imageHeight = 191;
        int inventoryMarginTop = imageHeight - 82;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, inventoryMarginTop + i * 18));
            }
        }
    }

    private final void addPlayerHotbar(Inventory playerInventory) {
        int imageHeight = 191;
        int inventoryMarginTop = imageHeight - 82;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, inventoryMarginTop + 58));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/xeli/createmetalogistics/screen/custom/TicketCrateMenu$Companion;", "", "<init>", "()V", "HOTBAR_SLOT_COUNT", "", "PLAYER_INVENTORY_ROW_COUNT", "PLAYER_INVENTORY_COLUMN_COUNT", "PLAYER_INVENTORY_SLOT_COUNT", "VANILLA_SLOT_COUNT", "VANILLA_FIRST_SLOT_INDEX", "TE_INVENTORY_FIRST_SLOT_INDEX", "TE_INVENTORY_SLOT_COUNT", "createmetalogistics-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

