/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.content.stations;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.xeli.createmetalogistics.GlobalStationHasChunkloaders;
import com.xeli.createmetalogistics.ModBlockEntities;
import com.xeli.createmetalogistics.content.stations.StationChunkLoaderBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J:\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u000f\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0014J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J0\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014\u00a8\u0006#"}, d2={"Lcom/xeli/createmetalogistics/content/stations/StationChunkLoaderBlock;", "Lnet/minecraft/world/level/block/Block;", "Lcom/simibubi/create/content/equipment/wrench/IWrenchable;", "Lnet/minecraft/world/level/block/EntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "level", "Lnet/minecraft/world/level/Level;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getOcclusionShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "onRemove", "", "newState", "movedByPiston", "", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "createmetalogistics-1.21.1"})
public final class StationChunkLoaderBlock
extends Block
implements IWrenchable,
EntityBlock {
    public StationChunkLoaderBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new StationChunkLoaderBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        if (blockEntityType == ModBlockEntities.INSTANCE.getStationChunkLoaderBlockEntityType().get()) {
            BlockEntityTicker<StationChunkLoaderBlockEntity> blockEntityTicker = StationChunkLoaderBlockEntity.Companion.getTicker();
            Intrinsics.checkNotNull(blockEntityTicker, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.entity.BlockEntityTicker<T of com.xeli.createmetalogistics.content.stations.StationChunkLoaderBlock.getTicker>");
            BlockEntityTicker<StationChunkLoaderBlockEntity> ticker = blockEntityTicker;
            return ticker;
        }
        return null;
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        VoxelShape shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        VoxelShape shape2 = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape voxelShape = Shapes.or((VoxelShape)shape, (VoxelShape)shape2);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"or(...)");
        return voxelShape;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof StationChunkLoaderBlockEntity) {
            ((StationChunkLoaderBlockEntity)be).onRemove(state, level, pos, newState);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        BlockEntity be = level.getBlockEntity(pos);
        ItemStack itemInHand = player.getMainHandItem();
        if (!itemInHand.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (be instanceof StationChunkLoaderBlockEntity) {
            StationBlockEntity target = ((StationChunkLoaderBlockEntity)be).getTarget();
            if (level.isClientSide) {
                player.swing(player.getUsedItemHand());
                InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
                return interactionResult;
            }
            if (target != null && target.getStation() != null) {
                GlobalStation globalStation = target.getStation();
                Intrinsics.checkNotNull((Object)globalStation);
                String stationName = globalStation.name;
                GlobalStation globalStation2 = target.getStation();
                Object object = globalStation2 instanceof GlobalStationHasChunkloaders ? (GlobalStationHasChunkloaders)globalStation2 : null;
                int stationLoaders = object != null && (object = object.getConnectedLoaders()) != null ? object.size() : 0;
                Object[] objectArray = new Object[]{stationName, stationLoaders};
                player.displayClientMessage((Component)Component.translatable((String)"message.createmetalogistics.station_chunk_loader.connected_info", (Object[])objectArray), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.createmetalogistics.station_chunk_loader.place_link_failed"), true);
            }
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        return InteractionResult.PASS;
    }
}

