/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.content.compiler;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.packager.PackagerBlock;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.foundation.block.IBE;
import com.xeli.createmetalogistics.ModBlockEntities;
import com.xeli.createmetalogistics.content.compiler.CompilerExpansionModuleBlock;
import com.xeli.createmetalogistics.content.compiler.CompilerExpansionModuleBlockEntity;
import com.xeli.createmetalogistics.content.compiler.StockManifestCompilerBlockEntity;
import com.xeli.createmetalogistics.content.reader.StockManifestReaderBlock;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u00015B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0014J\u0010\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010H\u0014J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eH\u0016J\u0010\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030 H\u0016J0\u0010!\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0014J@\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\u001e\u00100\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017J8\u00101\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020%H\u0016\u00a8\u00066"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlock;", "Lnet/minecraft/world/level/block/DirectionalBlock;", "Lcom/simibubi/create/foundation/block/IBE;", "Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity;", "Lcom/simibubi/create/content/equipment/wrench/IWrenchable;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "codec", "Lcom/mojang/serialization/MapCodec;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getOcclusionShape", "getStateForPlacement", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getBlockEntityClass", "Ljava/lang/Class;", "getBlockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "onRemove", "Lnet/minecraft/world/level/Level;", "newState", "movedByPiston", "", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "triggerManifest", "neighborChanged", "block", "fromPos", "isMoving", "Companion", "createmetalogistics-1.21.1"})
public final class StockManifestCompilerBlock
extends DirectionalBlock
implements IBE<StockManifestCompilerBlockEntity>,
IWrenchable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    @NotNull
    private static final MapCodec<StockManifestReaderBlock> CODEC;

    public StockManifestCompilerBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{DirectionalBlock.FACING, POWERED};
        builder.add(propertyArray);
    }

    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        return voxelShape;
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        VoxelShape shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        VoxelShape shape2 = Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        VoxelShape voxelShape = Shapes.or((VoxelShape)shape, (VoxelShape)shape2);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"or(...)");
        return voxelShape;
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    public Class<StockManifestCompilerBlockEntity> getBlockEntityClass() {
        return StockManifestCompilerBlockEntity.class;
    }

    @NotNull
    public BlockEntityType<? extends StockManifestCompilerBlockEntity> getBlockEntityType() {
        Object object = ModBlockEntities.INSTANCE.getStockManifestCompilerBlockEntityType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (BlockEntityType)object;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!Intrinsics.areEqual((Object)state.getBlock(), (Object)newState.getBlock())) {
            level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.INSTANCE.getStockManifestCompilerBlockEntityType().get()).ifPresent(arg_0 -> StockManifestCompilerBlock.onRemove$lambda$1(arg_0 -> StockManifestCompilerBlock.onRemove$lambda$0(level, pos, this, arg_0), arg_0));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.getItem() instanceof LogisticallyLinkedBlockItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (AllTags.AllItemTags.WRENCH.matches(itemInHand)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        StockManifestCompilerBlockEntity be = (StockManifestCompilerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!level.isClientSide && player instanceof ServerPlayer) {
                if (be.behaviour.mayInteractMessage(player)) {
                    ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)be, be.getDisplayName()), arg_0 -> StockManifestCompilerBlock.useItemOn$lambda$2(pos, be, arg_0));
                }
                ((ServerPlayer)player).swing(hand);
                ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
                return itemInteractionResult;
            }
            player.swing(hand);
            ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
            return itemInteractionResult;
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    public final void triggerManifest(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Optional blockEntityOptional = level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.INSTANCE.getStockManifestCompilerBlockEntityType().get());
        if (blockEntityOptional.isPresent()) {
            Object t = blockEntityOptional.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            StockManifestCompilerBlockEntity be = (StockManifestCompilerBlockEntity)((Object)t);
            List list = be.getAccurateSummary().getStacksByCount();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStacksByCount(...)");
            be.generateManifest(list);
        }
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        Boolean previouslyPowered = (Boolean)state.getValue((Property)PackagerBlock.POWERED);
        if (Intrinsics.areEqual((Object)previouslyPowered, (Object)level.hasNeighborSignal(pos))) {
            return;
        }
        level.setBlock(pos, (BlockState)state.cycle((Property)PackagerBlock.POWERED), 2);
        if (!previouslyPowered.booleanValue()) {
            this.triggerManifest(state, level, pos);
        }
    }

    private static final Unit onRemove$lambda$0(Level $level, BlockPos $pos, StockManifestCompilerBlock this$0, StockManifestCompilerBlockEntity it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        List positions = CollectionsKt.toList((Iterable)it.getConnectedModules());
        MinecraftServer server = $level.getServer();
        for (BlockPos modulePos : positions) {
            BlockState moduleState = $level.getBlockState(modulePos);
            Block block = moduleState.getBlock();
            BlockEntity be = $level.getBlockEntity(modulePos);
            if (be instanceof CompilerExpansionModuleBlockEntity) {
                ((CompilerExpansionModuleBlockEntity)be).setTargetRelativePos(Vec3i.ZERO);
            }
            if (!(block instanceof CompilerExpansionModuleBlock)) continue;
            CompilerExpansionModuleBlock compilerExpansionModuleBlock = (CompilerExpansionModuleBlock)block;
            Intrinsics.checkNotNull((Object)moduleState);
            BlockState moduleNewState = compilerExpansionModuleBlock.updateStateBasedOnDetectedStates(moduleState, $level, be, modulePos);
            $level.setBlockAndUpdate(modulePos, moduleNewState);
        }
        it.drops();
        $level.updateNeighbourForOutputSignal($pos, (Block)this$0);
        return Unit.INSTANCE;
    }

    private static final void onRemove$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void useItemOn$lambda$2(BlockPos $pos, StockManifestCompilerBlockEntity $be, RegistryFriendlyByteBuf it) {
        it.writeBlockPos($pos);
        it.writeEnum((Enum)$be.getSecurityPolicy());
        it.writeEnum((Enum)$be.getAcceptancePolicy());
        it.writeInt($be.validExpansionModules().size());
    }

    static {
        MapCodec mapCodec = DirectionalBlock.simpleCodec(StockManifestReaderBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlock$Companion;", "", "<init>", "()V", "POWERED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lcom/xeli/createmetalogistics/content/reader/StockManifestReaderBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "createmetalogistics-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<StockManifestReaderBlock> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

