/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import com.mojang.serialization.MapCodec;
import io.github.foundationgames.automobility.block.SpecialAutomobileColliderBlock;
import io.github.foundationgames.automobility.item.SlopePlacementContext;
import io.github.foundationgames.automobility.util.AUtils;
import io.github.foundationgames.automobility.util.duck.CollisionArea;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SlopeBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
SpecialAutomobileColliderBlock {
    public static final VoxelShape NORTH_BOTTOM_SHAPE;
    public static final VoxelShape SOUTH_BOTTOM_SHAPE;
    public static final VoxelShape EAST_BOTTOM_SHAPE;
    public static final VoxelShape WEST_BOTTOM_SHAPE;
    public static final VoxelShape NORTH_TOP_SHAPE;
    public static final VoxelShape SOUTH_TOP_SHAPE;
    public static final VoxelShape EAST_TOP_SHAPE;
    public static final VoxelShape WEST_TOP_SHAPE;
    public static final EnumProperty<Half> HALF;
    public static final BooleanProperty WATERLOGGED;
    public static final MapCodec<SlopeBlock> CODEC;

    public SlopeBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public CollisionArea getCollisionArea(BlockState state, Level level, BlockPos pos, double downStretch) {
        AABB bounds = new AABB((double)pos.getX(), (double)pos.getY() - 4.0 * downStretch, (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
        double originY = 0.25;
        if (state.getValue(HALF) == Half.TOP) {
            originY = 0.75;
        }
        double zSlope = 0.0;
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                zSlope = 0.5;
                break;
            }
            case SOUTH: {
                zSlope = -0.5;
            }
        }
        double xSlope = 0.0;
        switch ((Direction)state.getValue((Property)FACING)) {
            case EAST: {
                xSlope = -0.5;
                break;
            }
            case WEST: {
                xSlope = 0.5;
            }
        }
        return new CollisionArea.SlopeArea(bounds, xSlope, zSlope, originY);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState;
        if (ctx instanceof SlopePlacementContext) {
            SlopePlacementContext slopeCtx = (SlopePlacementContext)ctx;
            blockState = (BlockState)((BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)FACING, (Comparable)slopeCtx.getSlopeFacing())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos()).is(Blocks.WATER)))).setValue(HALF, (Comparable)slopeCtx.getSlopeHalf());
        } else {
            blockState = (BlockState)((BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos()).is(Blocks.WATER)))).setValue(HALF, (Comparable)(ctx.getClickLocation().y - (double)ctx.getClickedPos().getY() > 0.5 ? Half.TOP : Half.BOTTOM));
        }
        return blockState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, HALF, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Half)state.getValue(HALF)) {
            case Half.BOTTOM -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield NORTH_BOTTOM_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_BOTTOM_SHAPE;
                    }
                    case WEST: {
                        yield WEST_BOTTOM_SHAPE;
                    }
                    case EAST: {
                        yield EAST_BOTTOM_SHAPE;
                    }
                }
                yield Shapes.empty();
            }
            case Half.TOP -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield NORTH_TOP_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_TOP_SHAPE;
                    }
                    case WEST: {
                        yield WEST_TOP_SHAPE;
                    }
                    case EAST: {
                        yield EAST_TOP_SHAPE;
                    }
                }
                yield Shapes.empty();
            }
            default -> Shapes.empty();
        };
    }

    public static VoxelShape slopeStep(Direction dir, double height) {
        return switch (dir) {
            case Direction.NORTH -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)2.0);
            case Direction.SOUTH -> Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)height, (double)16.0);
            case Direction.EAST -> Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.WEST -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)height, (double)16.0);
            default -> Shapes.empty();
        };
    }

    static {
        HALF = BlockStateProperties.HALF;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        CODEC = Block.simpleCodec(SlopeBlock::new);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (Direction dir : AUtils.HORIZONTAL_DIRS) {
            for (int i = 0; i < 2; ++i) {
                double ox = switch (dir) {
                    case Direction.WEST -> 2.0;
                    case Direction.EAST -> -2.0;
                    default -> 0.0;
                };
                double oz = switch (dir) {
                    case Direction.NORTH -> 2.0;
                    case Direction.SOUTH -> -2.0;
                    default -> 0.0;
                };
                VoxelShape finalShape = Shapes.empty();
                for (int j = 0; j < 8; ++j) {
                    finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)SlopeBlock.slopeStep(dir, i * 8 + j).move(ox * (double)j / 16.0, 0.0, oz * (double)j / 16.0));
                }
                shapes.add(finalShape);
            }
        }
        NORTH_BOTTOM_SHAPE = (VoxelShape)shapes.get(0);
        NORTH_TOP_SHAPE = (VoxelShape)shapes.get(1);
        SOUTH_BOTTOM_SHAPE = (VoxelShape)shapes.get(2);
        SOUTH_TOP_SHAPE = (VoxelShape)shapes.get(3);
        EAST_BOTTOM_SHAPE = (VoxelShape)shapes.get(4);
        EAST_TOP_SHAPE = (VoxelShape)shapes.get(5);
        WEST_BOTTOM_SHAPE = (VoxelShape)shapes.get(6);
        WEST_TOP_SHAPE = (VoxelShape)shapes.get(7);
    }
}

