/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.blockentities;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.khloeleclair.create.additionallogistics.common.CALLang;
import dev.khloeleclair.create.additionallogistics.common.blocks.CashRegisterBlock;
import dev.khloeleclair.create.additionallogistics.common.data.CustomComponents;
import dev.khloeleclair.create.additionallogistics.common.data.SalesHistoryData;
import dev.khloeleclair.create.additionallogistics.common.menu.CashRegisterMenu;
import dev.khloeleclair.create.additionallogistics.common.registries.CALBlockEntityTypes;
import dev.khloeleclair.create.additionallogistics.common.registries.CALItems;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class CashRegisterBlockEntity
extends StockTickerBlockEntity {
    private ItemStack ledger = ItemStack.EMPTY;
    private final IItemHandlerModifiable ledgerHandler;
    public final CombinedInvWrapper invWrapper;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos blockPos, BlockState blockState) {
            CashRegisterBlockEntity.this.playSound(blockState, AllSoundEvents.STOCK_TICKER_TRADE.getMainEvent());
            CashRegisterBlockEntity.this.updateBlockState(blockState, true);
        }

        protected void onClose(Level level, BlockPos blockPos, BlockState blockState) {
            CashRegisterBlockEntity.this.updateBlockState(blockState, false);
        }

        protected void openerCountChanged(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
        }

        protected boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof CashRegisterMenu) {
                CashRegisterMenu menu = (CashRegisterMenu)abstractContainerMenu;
                return menu.contentHolder == CashRegisterBlockEntity.this;
            }
            return false;
        }
    };
    private int saleTicks = 0;

    public CashRegisterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.ledgerHandler = new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, ItemStack stack) {
                if (this.isItemValid(slot, stack)) {
                    CashRegisterBlockEntity.this.ledger = stack;
                }
            }

            public int getSlots() {
                return 1;
            }

            public ItemStack getStackInSlot(int slot) {
                return CashRegisterBlockEntity.this.ledger;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot != 1 && amount < 1) {
                    return ItemStack.EMPTY;
                }
                ItemStack result = CashRegisterBlockEntity.this.ledger;
                if (!simulate) {
                    CashRegisterBlockEntity.this.ledger = ItemStack.EMPTY;
                }
                CashRegisterBlockEntity.this.notifyUpdate();
                return result;
            }

            public int getSlotLimit(int slot) {
                return slot == 0 ? 1 : 0;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot != 0 || stack.isEmpty() || !stack.is(CALItems.SALES_LEDGER) || stack.getCount() != 1) {
                    return false;
                }
                SalesHistoryData history = (SalesHistoryData)stack.get(CustomComponents.SALES_HISTORY);
                return history == null || history.saleCount() < 1000;
            }
        };
        this.invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.receivedPayments, this.ledgerHandler});
    }

    public boolean hadRecentSale() {
        return this.saleTicks > 0;
    }

    void updateBlockState(BlockState state, boolean open) {
        if (this.level != null) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)CashRegisterBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        if (this.level == null) {
            return;
        }
        Vec3i face = ((Direction)state.getValue((Property)CashRegisterBlock.FACING)).getNormal();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)face.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)face.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)face.getZ() / 2.0;
        this.level.playSound(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator() && this.level != null) {
            this.openersCounter.incrementOpeners(player, this.level, this.worldPosition, this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator() && this.ledger != null) {
            this.openersCounter.decrementOpeners(player, this.level, this.worldPosition, this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove && this.level != null) {
            this.openersCounter.recheckOpeners(this.level, this.worldPosition, this.getBlockState());
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CALBlockEntityTypes.CASH_REGISTER.get(), (be, context) -> context == Direction.DOWN ? be.receivedPayments : (context == Direction.UP ? be.ledgerHandler : be.invWrapper));
    }

    public void tick() {
        super.tick();
        if (this.saleTicks > 0) {
            --this.saleTicks;
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.ledger != null && !this.ledger.isEmpty()) {
            tag.put("Ledger", this.ledger.save(registries));
        }
        tag.putInt("SaleTicks", this.saleTicks);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.ledger = ItemStack.EMPTY;
        if (tag.contains("Ledger", 10)) {
            this.ledger = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Ledger"));
        }
        this.saleTicks = tag.getInt("SaleTicks");
    }

    public static void recordSale(Level level, BlockPos pos, Player player, ItemStack mainHandItem) {
        BlockEntity blockEntity;
        if (level.isClientSide || mainHandItem.isEmpty() || !((blockEntity = level.getBlockEntity(pos)) instanceof CashRegisterBlockEntity)) {
            return;
        }
        CashRegisterBlockEntity be = (CashRegisterBlockEntity)blockEntity;
        if (player.getMainHandItem().equals(mainHandItem)) {
            return;
        }
        ShoppingListItem.ShoppingList list = ShoppingListItem.getList((ItemStack)mainHandItem);
        if (list == null) {
            return;
        }
        be.recordSale(player, list);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Object object;
        if (this.receivedPayments.isEmpty() && this.ledger.isEmpty()) {
            return false;
        }
        if (!this.behaviour.mayAdministrate((Player)Minecraft.getInstance().player)) {
            return false;
        }
        if (!this.ledger.isEmpty() && (object = this.ledger.get(CustomComponents.SALES_HISTORY)) instanceof SalesHistoryData) {
            SalesHistoryData history = (SalesHistoryData)object;
            CALLang.translate("sales.sales", CALLang.number(history.saleCount()).style(ChatFormatting.GOLD)).style(ChatFormatting.WHITE).forGoggles(tooltip);
            MutableComponent cmp = history.getTimeRange(ChatFormatting.AQUA);
            if (cmp != null) {
                CALLang.builder().add(cmp.withStyle(ChatFormatting.WHITE)).forGoggles(tooltip);
            }
            if (!this.receivedPayments.isEmpty()) {
                tooltip.add((Component)Component.literal((String)""));
            }
        }
        if (!this.receivedPayments.isEmpty()) {
            CreateLang.translate((String)"stock_ticker.contains_payments", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
            InventorySummary summary = new InventorySummary();
            for (int i = 0; i < this.receivedPayments.getSlots(); ++i) {
                summary.add(this.receivedPayments.getStackInSlot(i));
            }
            for (BigItemStack entry : summary.getStacksByCount()) {
                CreateLang.builder().text(Component.translatable((String)entry.stack.getDescriptionId()).getString() + " x" + entry.count).style(ChatFormatting.GREEN).forGoggles(tooltip);
            }
        }
        return true;
    }

    public void recordSale(Player player, ShoppingListItem.ShoppingList list) {
        SalesHistoryData history;
        Couple baked = list.bakeEntries((LevelAccessor)this.level, null);
        InventorySummary payment = (InventorySummary)baked.getSecond();
        InventorySummary order = (InventorySummary)baked.getFirst();
        SalesHistoryData salesHistoryData = history = this.ledger.isEmpty() ? null : (SalesHistoryData)this.ledger.get(CustomComponents.SALES_HISTORY);
        if (history == null) {
            history = SalesHistoryData.EMPTY;
        }
        if (history.saleCount() >= 1000) {
            this.ledger = ItemHandlerHelper.insertItem((IItemHandler)this.receivedPayments, (ItemStack)this.ledger, (boolean)false);
            if (this.ledger.isEmpty()) {
                history = SalesHistoryData.EMPTY;
            } else {
                return;
            }
        }
        history = history.withBigSale(player.getUUID(), payment.getStacks(), order.getStacks());
        if (this.ledger.isEmpty()) {
            this.ledger = CALItems.SALES_LEDGER.asStack();
        }
        this.ledger.set(CustomComponents.SALES_HISTORY, (Object)history);
        this.saleTicks = 20;
        this.notifyUpdate();
    }

    public class CashRegisterMenuProvider
    implements MenuProvider {
        @Nullable
        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return CashRegisterMenu.create(id, inventory, CashRegisterBlockEntity.this);
        }

        public Component getDisplayName() {
            return CashRegisterBlockEntity.this.getBlockState().getBlock().getName();
        }
    }
}

