/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.client.screen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import dev.khloeleclair.create.additionallogistics.client.registries.CALGuiTextures;
import dev.khloeleclair.create.additionallogistics.common.blockentities.CashRegisterBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.blocks.CashRegisterBlock;
import dev.khloeleclair.create.additionallogistics.common.menu.CashRegisterMenu;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.gui.ILightingSettings;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CashRegisterScreen
extends AbstractSimiContainerScreen<CashRegisterMenu> {
    private final CALGuiTextures background;
    private final BlockState icon;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public CashRegisterScreen(CashRegisterMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.background = CALGuiTextures.CASH_REGISTER_BG;
        this.icon = (BlockState)((BlockState)((CashRegisterBlockEntity)((Object)container.contentHolder)).getBlockState().setValue((Property)CashRegisterBlock.FACING, (Comparable)Direction.WEST)).setValue((Property)CashRegisterBlock.OPEN, (Comparable)Boolean.valueOf(true));
    }

    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight() + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.containerTick();
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.getWidth(), y + this.background.getHeight() - 50, 70, 60));
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.background.render(guiGraphics, x, y);
        Component title = this.getTitle();
        guiGraphics.drawString(this.font, title, Math.round((float)x + (float)this.background.getWidth() / 2.0f - (float)this.font.width((FormattedText)title) / 2.0f), y + 6, 0x442000, false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((BlockState)this.icon).at((float)(x + this.background.getWidth() + 16), (float)(y + this.background.getHeight() - 16), 0.0f)).scale(32.0).rotate(30.0, 45.0, 0.0).lighting(ILightingSettings.DEFAULT_3D).render(guiGraphics);
        int invX = this.leftPos + 30;
        int invY = this.topPos + 8 + this.imageHeight - AllGuiTextures.PLAYER_INVENTORY.getHeight();
        this.renderPlayerInventory(guiGraphics, invX, invY);
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

