/*
 * Decompiled with CFR 0.152.
 */
package com.divnectar.createblockchain.datagen;

import com.divnectar.createblockchain.datagen.ModBlockTagsProvider;
import com.divnectar.createblockchain.datagen.ModConfiguredFeatureProvider;
import com.divnectar.createblockchain.datagen.ModFluidTagsProvider;
import com.divnectar.createblockchain.datagen.ModGlobalLootModifiersProvider;
import com.divnectar.createblockchain.datagen.ModLootTableProvider;
import com.divnectar.createblockchain.datagen.ModPlacedFeatureProvider;
import com.divnectar.createblockchain.datagen.ModRecipeProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="createblockchain", bus=EventBusSubscriber.Bus.MOD)
public class ModDataGenerators {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ModConfiguredFeatureProvider::bootstrap).add(Registries.PLACED_FEATURE, ModPlacedFeatureProvider::bootstrap);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifiersProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModFluidTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, BUILDER, Set.of("createblockchain")));
    }
}

