/*
 * Decompiled with CFR 0.152.
 */
package com.divnectar.createblockchain.block.entity;

import com.divnectar.createblockchain.Config;
import com.divnectar.createblockchain.block.CurrencyMinerBlock;
import com.divnectar.createblockchain.block.ModBlocks;
import com.divnectar.createblockchain.fluid.ModFluids;
import com.divnectar.createblockchain.item.ModItems;
import com.divnectar.createblockchain.sound.ModSounds;
import com.divnectar.createblockchain.world.CurrencyTracker;
import com.mojang.logging.LogUtils;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CurrencyMinerBlockEntity
extends BlockEntity
implements GeoBlockEntity,
IHaveGoggleInformation {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_HEAT = 100;
    protected static final RawAnimation ACTIVE_ANIM = RawAnimation.begin().thenLoop("animation.Currency MinerGGL.transition");
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    private final EnergyStorage energyStorage;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2);
    private final FluidTank fluidTank = new FluidTank(4000);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long energyToMine;
    private long accumulatedEnergy = 0L;
    private int lastEnergyConsumed = 0;
    private double heat = 0.0;

    public CurrencyMinerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.CURRENCY_MINER_BE.get(), pos, state);
        this.energyStorage = new EnergyStorage(((Integer)Config.ENERGY_CAPACITY.get()).intValue(), ((Integer)Config.MAX_ENERGY_CONSUMPTION.get()).intValue(), ((Integer)Config.MAX_ENERGY_CONSUMPTION.get()).intValue());
        this.energyToMine = ((Integer)Config.BASE_ENERGY_PER_COIN.get()).intValue();
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CurrencyMinerBlockEntity be) {
        boolean isVisuallyActive;
        boolean isMakingProgress;
        if (level.isClientSide) {
            return;
        }
        be.updateMiningCost();
        boolean isBroken = be.isCoreBroken();
        boolean isOverheating = be.heat >= (double)((Integer)Config.OVERHEAT_THRESHOLD.get()).intValue();
        int potentialEnergyInput = be.energyStorage.extractEnergy(((Integer)Config.MAX_ENERGY_CONSUMPTION.get()).intValue(), true);
        boolean hasPower = potentialEnergyInput > 0;
        boolean bl = isMakingProgress = hasPower && !isBroken && !isOverheating;
        if (isMakingProgress) {
            be.processWork(potentialEnergyInput);
            be.lastEnergyConsumed = potentialEnergyInput;
        } else {
            be.lastEnergyConsumed = 0;
        }
        be.applyCooling();
        if (isOverheating && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.random.nextInt(4) == 0) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + level.random.nextDouble(), (double)pos.getY() + 1.2, (double)pos.getZ() + level.random.nextDouble(), 1, 0.0, 0.05, 0.0, 0.02);
            }
        }
        boolean bl2 = isVisuallyActive = hasPower && !isBroken;
        if ((Boolean)state.getValue((Property)CurrencyMinerBlock.POWERED) != isVisuallyActive) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CurrencyMinerBlock.POWERED, (Comparable)Boolean.valueOf(isVisuallyActive)), 3);
        }
        if (level.getGameTime() % 20L == 0L) {
            CurrencyMinerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            level.sendBlockUpdated(pos, state, state, 3);
        }
    }

    private void processWork(int energyConsumed) {
        this.energyStorage.extractEnergy(energyConsumed, false);
        double heatGenerated = (double)energyConsumed * (Double)Config.HEAT_PER_FE.get();
        this.heat = Math.min(100.0, this.heat + heatGenerated);
        this.accumulatedEnergy += (long)this.getEnergyWithHeatModifier(energyConsumed);
        if (this.accumulatedEnergy >= this.energyToMine) {
            int coinsToMine = (int)(this.accumulatedEnergy / this.energyToMine);
            for (int i = 0; i < coinsToMine; ++i) {
                this.mineCoin();
            }
            this.accumulatedEnergy %= this.energyToMine;
        }
    }

    private void applyCooling() {
        if (this.heat <= 0.0) {
            return;
        }
        double totalCoolingFactor = (Double)Config.PASSIVE_COOLING_PERCENT.get();
        if (!this.fluidTank.isEmpty()) {
            if (this.fluidTank.getFluid().getFluid() == Fluids.WATER) {
                totalCoolingFactor += ((Double)Config.WATER_COOLING_PERCENT.get()).doubleValue();
                this.fluidTank.drain(5, IFluidHandler.FluidAction.EXECUTE);
            } else if (this.fluidTank.getFluid().getFluid() == ModFluids.SOURCE_CRYOTHEUM_COOLANT.get()) {
                totalCoolingFactor += ((Double)Config.CRYOTHEUM_COOLING_PERCENT.get()).doubleValue();
                this.fluidTank.drain(5, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.heat *= 1.0 - totalCoolingFactor;
        if (this.heat < 0.0) {
            this.heat = 0.0;
        }
    }

    private boolean isCoreBroken() {
        ItemStack coreStack = this.itemHandler.getStackInSlot(1);
        return coreStack.isEmpty() || coreStack.getDamageValue() >= coreStack.getMaxDamage();
    }

    public ItemStack removeCoreForPlayer() {
        return this.itemHandler.extractItem(1, 1, false);
    }

    private int getEnergyWithHeatModifier(int energyIn) {
        if (this.heat > 75.0) {
            return energyIn / 2;
        }
        return energyIn;
    }

    private void mineCoin() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            Coin coinToMine;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack coreStack = this.itemHandler.getStackInSlot(1);
            if (coreStack.isEmpty() || !coreStack.is((Item)ModItems.MINING_CORE.get())) {
                return;
            }
            CurrencyTracker.get(serverLevel).incrementMined();
            int damage = (Integer)Config.DURABILITY_DAMAGE_STANDARD.get();
            if (!this.fluidTank.isEmpty() && this.fluidTank.getFluid().getFluid() == Fluids.WATER) {
                damage = (Integer)Config.DURABILITY_DAMAGE_WATER.get();
            }
            coreStack.hurtAndBreak(damage, serverLevel, null, item -> this.itemHandler.setStackInSlot(1, ItemStack.EMPTY));
            String coinTypeName = ((String)Config.COIN_TO_GENERATE.get()).toUpperCase();
            try {
                coinToMine = Coin.valueOf((String)coinTypeName);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Invalid coin type '{}' in config. Defaulting to BEVEL.", (Object)coinTypeName);
                coinToMine = Coin.BEVEL;
            }
            ItemStack coinStack = new ItemStack((ItemLike)coinToMine.asStack().getItem());
            this.itemHandler.insertItem(0, coinStack, false);
            serverLevel.playSound(null, this.worldPosition, (SoundEvent)ModSounds.COIN_CHACHING.get(), SoundSource.BLOCKS, 0.5f, 1.5f);
        }
    }

    private void updateMiningCost() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int totalMined = CurrencyTracker.get(serverLevel).getTotalMined();
            long difficultyBonus = (long)Math.floor((double)totalMined / (double)((Integer)Config.DIFFICULTY_INTERVAL.get()).intValue()) * (long)((Integer)Config.DIFFICULTY_BONUS.get()).intValue();
            long newEnergyToMine = (long)((Integer)Config.BASE_ENERGY_PER_COIN.get()).intValue() + difficultyBonus;
            if (this.energyToMine != newEnergyToMine) {
                this.energyToMine = newEnergyToMine;
                CurrencyMinerBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private PlayState predicate(AnimationState<CurrencyMinerBlockEntity> state) {
        if (((Boolean)((CurrencyMinerBlockEntity)state.getAnimatable()).getBlockState().getValue((Property)CurrencyMinerBlock.POWERED)).booleanValue()) {
            return state.setAndContinue(ACTIVE_ANIM);
        }
        return state.setAndContinue(IDLE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putLong("accumulatedEnergy", this.accumulatedEnergy);
        tag.put("energy", this.energyStorage.serializeNBT(provider));
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        tag.put("fluid", (Tag)this.fluidTank.writeToNBT(provider, new CompoundTag()));
        tag.putInt("lastEnergyConsumed", this.lastEnergyConsumed);
        tag.putLong("energyToMine", this.energyToMine);
        tag.putDouble("heat", this.heat);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.accumulatedEnergy = tag.getLong("accumulatedEnergy");
        if (tag.contains("energy", 10)) {
            this.energyStorage.deserializeNBT(provider, (Tag)tag.getCompound("energy"));
        }
        if (tag.contains("inventory", 10)) {
            this.itemHandler.deserializeNBT(provider, tag.getCompound("inventory"));
        }
        if (tag.contains("fluid")) {
            this.fluidTank.readFromNBT(provider, tag.getCompound("fluid"));
        }
        this.lastEnergyConsumed = tag.getInt("lastEnergyConsumed");
        this.energyToMine = tag.getLong("energyToMine");
        this.heat = tag.getDouble("heat");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String modId = "createblockchain";
        tooltip.add((Component)Component.translatable((String)("goggle." + modId + ".info.header")));
        ItemStack coreStack = this.itemHandler.getStackInSlot(1);
        if (coreStack.isEmpty()) {
            tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.no_core")).withStyle(ChatFormatting.RED)));
        } else {
            int currentDurability = coreStack.getMaxDamage() - coreStack.getDamageValue();
            int maxDurability = coreStack.getMaxDamage();
            tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.durability"))).append((Component)Component.literal((String)(": " + currentDurability + " / " + maxDurability)).withStyle((double)currentDurability < (double)maxDurability * 0.1 ? ChatFormatting.YELLOW : ChatFormatting.WHITE)));
        }
        if (this.heat >= (double)((Integer)Config.OVERHEAT_THRESHOLD.get()).intValue()) {
            tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.overheated")).withStyle(ChatFormatting.RED)));
        } else {
            tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.heat"))).append((Component)Component.literal((String)(": " + (int)this.heat + "%")).withStyle(this.heat > 75.0 ? ChatFormatting.YELLOW : ChatFormatting.WHITE)));
        }
        tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.coolant"))).append((Component)Component.literal((String)(": " + this.fluidTank.getFluidAmount() + "mb ")).append(this.fluidTank.getFluid().getDisplayName()).withStyle(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.usage"))).append((Component)Component.literal((String)(": " + this.lastEnergyConsumed + " FE/t")).withStyle(ChatFormatting.AQUA)));
        double coinsPerMinute = 0.0;
        if (this.lastEnergyConsumed > 0 && this.heat < (double)((Integer)Config.OVERHEAT_THRESHOLD.get()).intValue()) {
            double ticksPerCoin = (double)this.energyToMine / (double)this.getEnergyWithHeatModifier(this.lastEnergyConsumed);
            coinsPerMinute = 1200.0 / ticksPerCoin;
        }
        tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.rate"))).append((Component)Component.literal((String)String.format(": %.2f Coins/min", coinsPerMinute)).withStyle(ChatFormatting.GREEN)));
        tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.cost"))).append((Component)Component.literal((String)(": " + this.energyToMine + " FE")).withStyle(ChatFormatting.GOLD)));
        ItemStack storedStack = this.itemHandler.getStackInSlot(0);
        tooltip.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)("goggle." + modId + ".info.stored"))).append((Component)Component.literal((String)(": " + storedStack.getCount() + " ")).append(storedStack.getHoverName()).withStyle(ChatFormatting.WHITE)));
        return true;
    }
}

