/*
 * Decompiled with CFR 0.152.
 */
package com.divnectar.createblockchain.block;

import com.divnectar.createblockchain.block.entity.PiggyBankBlockEntity;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PiggyBankBlock
extends BaseEntityBlock
implements IWrenchable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<PiggyBankBlock> CODEC = PiggyBankBlock.simpleCodec(PiggyBankBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public PiggyBankBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PiggyBankBlockEntity(pPos, pState);
    }

    private int getWeightedCoinAmount(RandomSource random) {
        float chance = random.nextFloat();
        if (chance < 0.01f) {
            return 250;
        }
        if (chance < 0.1f) {
            return random.nextInt(151, 250);
        }
        if (chance < 0.4f) {
            return random.nextInt(51, 151);
        }
        return random.nextInt(6, 51);
    }
}

