/*
 * Decompiled with CFR 0.152.
 */
package com.divnectar.createblockchain.block;

import com.divnectar.createblockchain.block.ModBlocks;
import com.divnectar.createblockchain.block.entity.CurrencyMinerBlockEntity;
import com.divnectar.createblockchain.item.ModItems;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CurrencyMinerBlock
extends BaseEntityBlock
implements IWrenchable {
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<CurrencyMinerBlock> CODEC = CurrencyMinerBlock.simpleCodec(CurrencyMinerBlock::new);

    public CurrencyMinerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof CurrencyMinerBlockEntity) {
            ItemStack remainder;
            CurrencyMinerBlockEntity minerEntity = (CurrencyMinerBlockEntity)blockEntity;
            ItemStack heldItem = pPlayer.getItemInHand(pHand);
            if (pPlayer.isShiftKeyDown() && heldItem.isEmpty()) {
                ItemStack coreStack = minerEntity.removeCoreForPlayer();
                if (!coreStack.isEmpty()) {
                    pPlayer.setItemInHand(pHand, coreStack);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (heldItem.is((Item)ModItems.MINING_CORE.get()) && (remainder = minerEntity.getItemHandler().insertItem(1, heldItem, false)).getCount() < heldItem.getCount()) {
                pPlayer.setItemInHand(pHand, remainder);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CurrencyMinerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return CurrencyMinerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlocks.CURRENCY_MINER_BE.get()), CurrencyMinerBlockEntity::tick);
    }
}

