/*
 * Decompiled with CFR 0.152.
 */
package com.divnectar.createblockchain;

import com.divnectar.createblockchain.Config;
import com.divnectar.createblockchain.block.ModBlocks;
import com.divnectar.createblockchain.client.CurrencyMinerRenderer;
import com.divnectar.createblockchain.client.PiggyBankRenderer;
import com.divnectar.createblockchain.fluid.ModFluidTypes;
import com.divnectar.createblockchain.fluid.ModFluids;
import com.divnectar.createblockchain.item.ModCreativeModeTabs;
import com.divnectar.createblockchain.item.ModItems;
import com.divnectar.createblockchain.item.RemoteFinderItem;
import com.divnectar.createblockchain.setup.ModLootModifiers;
import com.divnectar.createblockchain.sound.ModSounds;
import com.divnectar.createblockchain.util.CapabilityRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="createblockchain")
public class CreateBlockchain {
    public static final String MODID = "createblockchain";
    private static final Logger LOGGER = LogUtils.getLogger();

    public CreateBlockchain(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        LOGGER.info("Initializing Create: Blockchain for Minecraft 1.21.1");
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModSounds.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        ModFluids.register(modEventBus);
        ModFluidTypes.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        modEventBus.register((Object)new CapabilityRegistry());
        RemoteFinderItem.registerDataComponents(modEventBus);
        modEventBus.addListener(RemoteFinderItem.CapabilityHooks::registerCaps);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::registerRenderers);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.CURRENCY_MINER_BE.get(), CurrencyMinerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.PIGGY_BANK_BE.get(), PiggyBankRenderer::new);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

