/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.common.ItemActionHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemTransfersPayload;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public record RestockItemsPayload(ItemStack filter, int minSlot, int maxSlot, boolean fillEmpty, List<BlockPos> storagePositions, Map<ResourceLocation, Object> extras) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RestockItemsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("restock_items"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RestockItemsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, RestockItemsPayload::filter, (StreamCodec)ByteBufCodecs.INT, RestockItemsPayload::minSlot, (StreamCodec)ByteBufCodecs.INT, RestockItemsPayload::maxSlot, (StreamCodec)ByteBufCodecs.BOOL, RestockItemsPayload::fillEmpty, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), RestockItemsPayload::storagePositions, ItemActionHandlerRegistry.EXTRAS_STREAM_CODEC, RestockItemsPayload::extras, RestockItemsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(RestockItemsPayload payload, IPayloadContext context) {
        MutableComponent message;
        Player player = context.player();
        Level level = player.level();
        TreeMap<Vec3, InventoryHandler> restockHandlers = new TreeMap<Vec3, InventoryHandler>(Comparator.comparingDouble(arg_0 -> ((Player)player).distanceToSqr(arg_0)).thenComparingDouble(Vec3::x).thenComparingDouble(Vec3::y).thenComparingDouble(Vec3::z));
        payload.storagePositions().stream().filter(pos -> player.mayInteract(level, pos)).map(pos -> WorldHelper.getBlockEntity((BlockGetter)level, pos, IControllableStorage.class)).filter(Optional::isPresent).map(Optional::get).forEach(s -> restockHandlers.put(s.getStorageBlockPos().getCenter(), s.getStorageWrapper().getInventoryHandler()));
        payload.extras().forEach((id, extraData) -> ItemActionHandlerRegistry.get(id).ifPresent(handler -> restockHandlers.putAll(RestockItemsPayload.getTargetInventories(handler, player, extraData))));
        ItemStackKey filterStackKey = ItemStackKey.of(payload.filter());
        HashMap<Vec3, ItemStack> transferredItems = new HashMap<Vec3, ItemStack>();
        HashSet<Integer> restockedPlayerSlots = new HashSet<Integer>();
        for (int playerInventorySlot = payload.minSlot(); playerInventorySlot < payload.maxSlot(); ++playerInventorySlot) {
            ItemStack playerInventoryStack = player.getInventory().getItem(playerInventorySlot);
            if (payload.fillEmpty() && !payload.filter().isEmpty()) {
                if (!playerInventoryStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)playerInventoryStack, (ItemStack)payload.filter())) continue;
                RestockItemsPayload.restockSlot(restockHandlers, filterStackKey, playerInventoryStack, transferredItems, restockedPlayerSlots, player, playerInventorySlot);
                continue;
            }
            if (playerInventoryStack.isEmpty()) continue;
            RestockItemsPayload.restockSlot(restockHandlers, ItemStackKey.of(playerInventoryStack), playerInventoryStack, transferredItems, restockedPlayerSlots, player, playerInventorySlot);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Vec3 playerPos = player.getEyePosition().add(0.0, -0.3, 0.0);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncItemTransfersPayload(transferredItems, playerPos, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)new SyncItemTransfersPayload(transferredItems, playerPos, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (payload.maxSlot() - payload.minSlot() == 1) {
            if (transferredItems.isEmpty()) {
                ItemStack item = payload.fillEmpty() ? filterStackKey.getStack() : player.getInventory().getItem(payload.minSlot());
                message = TranslationHelper.INSTANCE.translStatusMessage("cannot_restock_item", Component.literal((String)item.getHoverName().getString()).withStyle(ChatFormatting.RED));
                player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.random) * 0.1f);
            } else {
                message = TranslationHelper.INSTANCE.translStatusMessage("restocked_item", Component.literal((String)((ItemStack)transferredItems.values().iterator().next()).getHoverName().getString()).withStyle(ChatFormatting.DARK_GREEN));
            }
        } else if (transferredItems.isEmpty()) {
            message = TranslationHelper.INSTANCE.translStatusMessage("cannot_restock_items", new Object[0]);
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.random) * 0.1f);
        } else {
            message = TranslationHelper.INSTANCE.translStatusMessage("restocked_items", Component.literal((String)String.valueOf(restockedPlayerSlots.size())).withStyle(ChatFormatting.DARK_GREEN));
        }
        player.displayClientMessage((Component)message, true);
    }

    private static void restockSlot(Map<Vec3, InventoryHandler> restockHandlers, ItemStackKey stackKey, ItemStack playerInventoryStack, Map<Vec3, ItemStack> restocked, Set<Integer> restockedPlayerSlots, Player player, int playerInventorySlot) {
        for (Map.Entry<Vec3, InventoryHandler> entry : restockHandlers.entrySet()) {
            Vec3 pos = entry.getKey();
            InventoryHandler handler = entry.getValue();
            int matchingStackSlot = handler.getSlotTracker().getFirstMatchingSlot(stackKey);
            while (matchingStackSlot != -1 && playerInventoryStack.getCount() < playerInventoryStack.getMaxStackSize()) {
                ItemStack extracted = handler.extractItem(matchingStackSlot, playerInventoryStack.getMaxStackSize() - playerInventoryStack.getCount(), false);
                if (!extracted.isEmpty()) {
                    restocked.put(pos, extracted.copyWithCount(restocked.getOrDefault(pos, ItemStack.EMPTY).getCount() + extracted.getCount()));
                    if (playerInventoryStack.isEmpty()) {
                        playerInventoryStack = extracted.copy();
                    } else {
                        playerInventoryStack.grow(extracted.getCount());
                    }
                    player.getInventory().setItem(playerInventorySlot, playerInventoryStack);
                    restockedPlayerSlots.add(playerInventorySlot);
                }
                matchingStackSlot = handler.getSlotTracker().getFirstMatchingSlot(stackKey);
            }
        }
    }

    private static <T> Map<Vec3, InventoryHandler> getTargetInventories(IItemActionPayloadHandler<T> handler, Player player, Object extraData) {
        return handler.getTargetInventories(player, extraData);
    }
}

