/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.block.DoublePlantBlockBOP;
import biomesoplenty.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrimstoneClusterBlock
extends DoublePlantBlockBOP {
    protected static final VoxelShape SHAPE = BrimstoneClusterBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape SHAPE_TOP = BrimstoneClusterBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);

    public BrimstoneClusterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_TOP;
        }
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldReader, BlockPos pos) {
        if (state.getBlock() != this) {
            return super.canSurvive(state, worldReader, pos);
        }
        if (state.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            BlockState soil = worldReader.getBlockState(pos.below());
            return soil.is(ModTags.Blocks.BRIMSTONE_DECORATION_PLACEABLE) && soil.isFaceSturdy((BlockGetter)worldReader, pos.below(), Direction.UP);
        }
        BlockState below = worldReader.getBlockState(pos.below());
        return below.getBlock() == this && below.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }
}

