/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.recipe.RecipeProperties;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public final class PrintoutRecipe
extends ShapelessRecipe {
    public static final MapCodec<PrintoutRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapelessRecipeSpec.CODEC.forGetter(PrintoutRecipe::toSpec), (App)Ingredient.CODEC_NONEMPTY.fieldOf("printout").forGetter(x -> x.printout), (App)ExtraCodecs.POSITIVE_INT.fieldOf("min_printouts").forGetter(x -> x.minPrintouts)).apply((Applicative)instance, PrintoutRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PrintoutRecipe> STREAM_CODEC = StreamCodec.composite(ShapelessRecipeSpec.STREAM_CODEC, PrintoutRecipe::toSpec, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, x -> x.printout, (StreamCodec)ByteBufCodecs.VAR_INT, x -> x.minPrintouts, PrintoutRecipe::new);
    private final NonNullList<Ingredient> ingredients;
    private final Ingredient printout;
    private final int minPrintouts;
    private final ShapelessRecipe innerRecipe;
    private final ItemStack result;

    public PrintoutRecipe(ShapelessRecipeSpec spec, Ingredient printout, int minPrintouts) {
        super(spec.properties().group(), spec.properties().category(), spec.result(), PrintoutRecipe.concat(spec.ingredients(), printout, minPrintouts));
        this.ingredients = spec.ingredients();
        this.printout = printout;
        this.minPrintouts = minPrintouts;
        this.result = spec.result();
        this.innerRecipe = spec.create();
    }

    private static NonNullList<Ingredient> concat(NonNullList<Ingredient> first, Ingredient pages, int pagesRequired) {
        NonNullList result = NonNullList.withSize((int)(first.size() + pagesRequired), (Object)Ingredient.EMPTY);
        int idx = 0;
        for (Ingredient ingredient : first) {
            result.set(idx++, (Object)ingredient);
        }
        for (int i = 0; i < pagesRequired; ++i) {
            result.set(idx++, (Object)pages);
        }
        return result;
    }

    private ShapelessRecipeSpec toSpec() {
        return new ShapelessRecipeSpec(RecipeProperties.of((CraftingRecipe)this), this.ingredients, this.result);
    }

    public boolean matches(CraftingInput inv, Level world) {
        StackedContents stackedContents = new StackedContents();
        int inputs = 0;
        int printouts = 0;
        int pages = 0;
        boolean hasPrintout = false;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack stack = inv.getItem(j);
            if (stack.isEmpty()) continue;
            if (this.printout.test(stack)) {
                ++printouts;
                PrintoutData printout = (PrintoutData)stack.get((DataComponentType)ModRegistry.DataComponents.PRINTOUT.get());
                if (printout == null) {
                    ++pages;
                    continue;
                }
                hasPrintout = true;
                pages += printout.pages();
                continue;
            }
            ++inputs;
            stackedContents.accountStack(stack, 1);
        }
        return hasPrintout && printouts >= this.minPrintouts && pages <= 16 && inputs == this.ingredients.size() && stackedContents.canCraft((Recipe)this.innerRecipe, null);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ArrayList<PrintoutData> data = new ArrayList<PrintoutData>();
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack stack = inv.getItem(j);
            if (stack.isEmpty() || !this.printout.test(stack)) continue;
            data.add(PrintoutData.getOrEmpty((DataComponentHolder)stack));
        }
        if (data.isEmpty()) {
            throw new IllegalStateException("Printouts must be non-null");
        }
        List<PrintoutData.Line> lines = data.stream().flatMap(x -> x.lines().stream()).toList();
        ItemStack result = super.assemble(inv, registries);
        result.set((DataComponentType)ModRegistry.DataComponents.PRINTOUT.get(), (Object)new PrintoutData(((PrintoutData)data.getFirst()).title(), lines));
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.PRINTOUT.get();
    }
}

