/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.integration.jei;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.client.integration.jei.RecipeResolver;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

@JeiPlugin
public class JEIComputerCraft
implements IModPlugin {
    private static final IIngredientSubtypeInterpreter<ItemStack> turtleSubtype = (stack, ctx) -> {
        StringBuilder name = new StringBuilder("turtle:");
        UpgradeData<ITurtleUpgrade> left = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
        UpgradeData<ITurtleUpgrade> right = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
        if (left != null) {
            name.append(left.holder().key().location());
        }
        if (left != null && right != null) {
            name.append('|');
        }
        if (right != null) {
            name.append(right.holder().key().location());
        }
        return name.toString();
    };
    private static final IIngredientSubtypeInterpreter<ItemStack> pocketSubtype = (stack, ctx) -> {
        StringBuilder name = new StringBuilder("pocket:");
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        if (upgrade != null) {
            name.append(upgrade.holder().key().location());
        }
        return name.toString();
    };
    private static final IIngredientSubtypeInterpreter<ItemStack> diskSubtype = (stack, ctx) -> Integer.toString(DyedItemColor.getOrDefault((ItemStack)stack, (int)-1));

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"jei");
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModRegistry.Items.TURTLE_NORMAL.get()), turtleSubtype);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModRegistry.Items.TURTLE_ADVANCED.get()), turtleSubtype);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()), pocketSubtype);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get()), pocketSubtype);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModRegistry.Items.DISK.get()), diskSubtype);
    }

    public void registerAdvanced(IAdvancedRegistration registry) {
        registry.addRecipeManagerPlugin((IRecipeManagerPlugin)new RecipeResolver((HolderLookup.Provider)JEIComputerCraft.getRegistryAccess()));
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        IRecipeManager registry = runtime.getRecipeManager();
        List<ItemStack> upgradeItems = RecipeModHelpers.getExtraStacks((HolderLookup.Provider)JEIComputerCraft.getRegistryAccess());
        if (!upgradeItems.isEmpty()) {
            runtime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, upgradeItems);
        }
        IRecipeLookup category = registry.createRecipeLookup(RecipeTypes.CRAFTING);
        category.get().forEach(wrapper -> {
            if (RecipeModHelpers.shouldRemoveRecipe(wrapper.id())) {
                registry.hideRecipes(RecipeTypes.CRAFTING, List.of(wrapper));
            }
        });
    }

    private static RegistryAccess getRegistryAccess() {
        return Minecraft.getInstance().level.registryAccess();
    }
}

