/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.param;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.slf4j.Logger;

public record ReplaceParametersTransformer(int index, Type type, boolean upgradeUsage) implements ParameterTransformer
{
    static final Codec<ReplaceParametersTransformer> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.intRange((int)0, (int)255).fieldOf("index").forGetter(ReplaceParametersTransformer::index), (App)AdapterUtil.TYPE_CODEC.fieldOf("type").forGetter(ReplaceParametersTransformer::type)).apply((Applicative)in, ReplaceParametersTransformer::new));
    private static final Logger LOGGER = LogUtils.getLogger();

    public ReplaceParametersTransformer(int index, Type type) {
        this(index, type, true);
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, List<Type> parameters, int offset) {
        int paramIndex = this.index + offset;
        if (methodNode.parameters.size() <= paramIndex) {
            return Patch.Result.PASS;
        }
        LOGGER.info(PatchInstance.MIXINPATCH, "Replacing parameter {} with type {} in {}.{}", new Object[]{paramIndex, this.type, classNode.name, methodNode.name});
        parameters.set(paramIndex, this.type);
        LocalVariableLookup lvtLookup = new LocalVariableLookup(methodNode);
        LocalVariableNode localVar = lvtLookup.getByParameterOrdinal(paramIndex);
        Type originalType = Type.getType((String)localVar.desc);
        localVar.desc = this.type.getDescriptor();
        localVar.signature = null;
        List<AbstractInsnNode> ignoreInsns = ParamTransformationUtil.findWrapOperationOriginalCall(methodNode, methodContext);
        BytecodeFixerUpper bfu = context.environment().bytecodeFixerUpper();
        if (this.upgradeUsage && this.type.getSort() == 10 && originalType.getSort() == 10) {
            block0: for (AbstractInsnNode insn : methodNode.instructions) {
                AbstractInsnNode previous;
                if (ignoreInsns.contains(insn)) continue;
                if (insn instanceof VarInsnNode) {
                    VarInsnNode varInsn = (VarInsnNode)insn;
                    if (varInsn.var == localVar.index) {
                        TypeAdapter typeFix;
                        int nextOp = insn.getNext().getOpcode();
                        if (bfu != null && nextOp != 198 && nextOp != 199 && (typeFix = bfu.getTypeAdapter(this.type, originalType)) != null) {
                            typeFix.apply(methodNode.instructions, (AbstractInsnNode)varInsn);
                            break;
                        }
                    }
                }
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode minsn = (MethodInsnNode)insn;
                if (!minsn.owner.equals(originalType.getInternalName()) || (previous = minsn.getPrevious()) == null) continue;
                while (!(previous instanceof LabelNode) && !(previous instanceof LineNumberNode)) {
                    if (previous instanceof VarInsnNode) {
                        VarInsnNode varinsn = (VarInsnNode)previous;
                        if (varinsn.var == localVar.index) {
                            minsn.owner = this.type.getInternalName();
                            continue block0;
                        }
                    }
                    if ((previous = previous.getPrevious()) != null) continue;
                    continue block0;
                }
            }
        }
        return Patch.Result.COMPUTE_FRAMES;
    }

    @Override
    public Codec<? extends ParameterTransformer> codec() {
        return CODEC;
    }
}

