/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.CompoundMethodTransform;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.OpcodeUtil;

public record MirrorableExtractMixin(String destinationClass, MethodInsnNode destinationMethodInvocation) implements MethodTransform
{
    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        VarInsnNode varInsn;
        Type selfType = Type.getObjectType((String)methodContext.findDirtyInjectionTarget().classNode().name);
        Type[] params = Type.getArgumentTypes((String)this.destinationMethodInvocation.desc);
        int selfIndex = Stream.of(Stream.iterate(0, i -> i < params.length, i -> i + 1).filter(i -> params[i].equals((Object)selfType)).toList()).filter(list -> list.size() == 1).map(List::getFirst).findFirst().orElse(-1);
        if (selfIndex == -1) {
            return Patch.Result.PASS;
        }
        List<AbstractInsnNode> callInsns = MethodCallAnalyzer.findMethodCallParamInsns(methodContext.findDirtyInjectionTarget().methodNode(), this.destinationMethodInvocation);
        if (callInsns == null || callInsns.size() <= selfIndex) {
            return Patch.Result.PASS;
        }
        AbstractInsnNode selfParamInsn = callInsns.get(selfIndex);
        if (!(selfParamInsn instanceof VarInsnNode) || (varInsn = (VarInsnNode)selfParamInsn).getOpcode() != 25 || varInsn.var != 0) {
            return Patch.Result.PASS;
        }
        ClassNode generatedTarget = methodContext.patchContext().environment().classGenerator().getOrGenerateMixinClass(methodContext.getMixinClass(), this.destinationClass, null);
        methodContext.patchContext().environment().refmapHolder().copyEntries(methodContext.getMixinClass().name, generatedTarget.name);
        MethodNode originalMixinMethod = methodContext.getMixinMethod();
        String name = originalMixinMethod.name + "$adapter$mirror$" + AdapterUtil.randomString(5);
        List<Type> originalParams = List.of(Type.getArgumentTypes((String)originalMixinMethod.desc));
        ImmutableList newParams = ImmutableList.builder().add((Object[])Type.getArgumentTypes((String)this.destinationMethodInvocation.desc)).add((Object)AdapterUtil.CI_TYPE).build();
        if (!new HashSet(newParams).containsAll(originalParams)) {
            return Patch.Result.PASS;
        }
        String desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])((Type[])newParams.toArray(Type[]::new)));
        CompoundMethodTransform.builder(b -> b.modifyTarget(this.destinationMethodInvocation.name + this.destinationMethodInvocation.desc)).apply(methodContext);
        MethodNode invokerMixinMethod = (MethodNode)generatedTarget.visitMethod(10, name, desc, null, null);
        invokerMixinMethod.visibleAnnotations = new ArrayList(originalMixinMethod.visibleAnnotations);
        originalMixinMethod.access = OpcodeUtil.setAccessVisibility(originalMixinMethod.access, 1);
        originalMixinMethod.visibleAnnotations.remove(methodContext.methodAnnotation().unwrap());
        originalMixinMethod.visitAnnotation("Lorg/spongepowered/asm/mixin/Unique;", true);
        GeneratorAdapter gen = new GeneratorAdapter((MethodVisitor)invokerMixinMethod, invokerMixinMethod.access, invokerMixinMethod.name, invokerMixinMethod.desc);
        gen.newLabel();
        gen.loadArg(selfIndex);
        for (Type type : originalParams) {
            gen.loadArg(newParams.indexOf(type));
        }
        gen.invokeVirtual(selfType, new Method(originalMixinMethod.name, originalMixinMethod.desc));
        gen.newLabel();
        gen.returnValue();
        gen.newLabel();
        gen.endMethod();
        return Patch.Result.APPLY;
    }
}

