/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.MethodContextImpl;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.analysis.selector.InjectionPointMatcher;
import org.sinytra.adapter.patch.analysis.selector.MethodMatcher;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.transformer.operation.unit.DisableMixin;
import org.sinytra.adapter.patch.transformer.operation.unit.DivertRedirectorTransform;
import org.sinytra.adapter.patch.transformer.operation.unit.ModifyInjectionPoint;
import org.sinytra.adapter.patch.transformer.serialization.MethodTransformSerialization;
import org.sinytra.adapter.patch.util.MethodQualifier;

public final class ClassPatchInstance
extends PatchInstance {
    public static final Codec<ClassPatchInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("targetClasses", List.of()).forGetter(p -> p.targetClasses), (App)MethodMatcher.CODEC.listOf().optionalFieldOf("targetMethods", List.of()).forGetter(p -> p.targetMethods), (App)InjectionPointMatcher.CODEC.listOf().optionalFieldOf("targetInjectionPoints", List.of()).forGetter(p -> p.targetInjectionPoints), (App)Codec.STRING.listOf().optionalFieldOf("targetAnnotations", List.of()).forGetter(p -> p.targetAnnotations), (App)MethodTransformSerialization.METHOD_TRANSFORM_CODEC.listOf().fieldOf("transforms").forGetter(p -> p.transforms)).apply((Applicative)instance, ClassPatchInstance::new)).flatComapMap(Function.identity(), obj -> obj.targetAnnotationValues != null ? DataResult.error(() -> "Cannot serialize targetAnnotationValues") : DataResult.success((Object)obj));
    private final List<MethodMatcher> targetMethods;
    private final List<InjectionPointMatcher> targetInjectionPoints;

    private ClassPatchInstance(List<String> targetClasses, List<MethodMatcher> targetMethods, List<InjectionPointMatcher> targetInjectionPoints, List<String> targetAnnotations, List<MethodTransform> transforms) {
        this(targetClasses, targetMethods, targetInjectionPoints, targetAnnotations, map -> true, List.of(), transforms);
    }

    private ClassPatchInstance(List<String> targetClasses, List<MethodMatcher> targetMethods, List<InjectionPointMatcher> targetInjectionPoints, List<String> targetAnnotations, Predicate<AnnotationHandle> targetAnnotationValues, List<ClassTransform> classTransforms, List<MethodTransform> transforms) {
        super(targetClasses, targetAnnotations, targetAnnotationValues, classTransforms, transforms);
        this.targetMethods = targetMethods;
        this.targetInjectionPoints = targetInjectionPoints;
    }

    @Override
    public Codec<? extends PatchInstance> codec() {
        return CODEC;
    }

    @Override
    protected boolean checkAnnotation(String owner, MethodNode method, AnnotationHandle methodAnnotation, PatchEnvironment remaper, MethodContextImpl.Builder builder) {
        builder.methodNode(method);
        builder.methodAnnotation(methodAnnotation);
        if (methodAnnotation.matchesDesc("Lorg/spongepowered/asm/mixin/Overwrite;")) {
            return this.targetMethods.isEmpty() || this.targetMethods.stream().anyMatch(matcher -> matcher.matches(method.name, method.desc));
        }
        if (KNOWN_MIXIN_TYPES.contains(methodAnnotation.getDesc())) {
            return methodAnnotation.getValue("method").map(value -> {
                ArrayList<String> matchingTargets = new ArrayList<String>();
                for (String target : (List)value.get()) {
                    String remappedTarget = remaper.refmapHolder().remap(owner, target);
                    MethodQualifier qualifier = MethodQualifier.create(remappedTarget).filter(q -> q.name() != null).orElse(null);
                    if (qualifier == null) continue;
                    String targetName = qualifier.name();
                    String targetDesc = qualifier.desc();
                    if (!this.targetMethods.isEmpty() && !this.targetMethods.stream().anyMatch(matcher -> matcher.matches(targetName, targetDesc)) || !this.checkInjectionPoint(owner, methodAnnotation, remaper, builder)) continue;
                    matchingTargets.add(target);
                }
                builder.matchingTargets(matchingTargets);
                return !matchingTargets.isEmpty();
            }).orElse(false);
        }
        return false;
    }

    private boolean checkInjectionPoint(String owner, AnnotationHandle methodAnnotation, PatchEnvironment environment, MethodContextImpl.Builder builder) {
        return methodAnnotation.getNested("at").flatMap(node -> this.checkInjectionPointAnnotation(owner, (AnnotationHandle)node, environment, builder)).or(() -> methodAnnotation.getValue("slice").flatMap(slice -> slice.findNested("from").flatMap(from -> this.checkInjectionPointAnnotation(owner, (AnnotationHandle)from, environment, builder)))).orElse(this.targetInjectionPoints.isEmpty());
    }

    private Optional<Boolean> checkInjectionPointAnnotation(String owner, AnnotationHandle injectionPointAnnotation, PatchEnvironment environment, MethodContextImpl.Builder builder) {
        AnnotationValueHandle value = injectionPointAnnotation.getValue("value").orElse(null);
        String valueStr = value != null ? (String)value.get() : null;
        String targetStr = injectionPointAnnotation.getValue("target").map(t -> environment.refmapHolder().remap(owner, (String)t.get())).orElse("");
        if (this.targetInjectionPoints.isEmpty() || this.targetInjectionPoints.stream().anyMatch(pred -> pred.test(valueStr, targetStr))) {
            builder.injectionPointAnnotation(injectionPointAnnotation);
            return Optional.of(true);
        }
        return Optional.empty();
    }

    public static class ClassPatchBuilderImpl
    extends PatchInstance.BaseBuilder<Patch.ClassPatchBuilder>
    implements Patch.ClassPatchBuilder {
        private final Set<MethodMatcher> targetMethods = new HashSet<MethodMatcher>();
        private final Set<InjectionPointMatcher> targetInjectionPoints = new HashSet<InjectionPointMatcher>();

        @Override
        public Patch.ClassPatchBuilder targetMethod(String ... targets) {
            for (String target : targets) {
                this.targetMethods.add(new MethodMatcher(target));
            }
            return this;
        }

        @Override
        public Patch.ClassPatchBuilder targetInjectionPoint(String value, String target) {
            this.targetInjectionPoints.add(new InjectionPointMatcher(value, target));
            return this;
        }

        @Override
        public Patch.ClassPatchBuilder modifyInjectionPoint(String value, String target, boolean resetValues) {
            return this.modifyInjectionPoint(value, target, resetValues, false);
        }

        @Override
        public Patch.ClassPatchBuilder modifyInjectionPoint(String value, String target, boolean resetValues, boolean dontUpgrade) {
            return (Patch.ClassPatchBuilder)this.transform(new ModifyInjectionPoint(value, target, resetValues, dontUpgrade));
        }

        @Override
        public Patch.ClassPatchBuilder divertRedirector(Consumer<InstructionAdapter> patcher) {
            return (Patch.ClassPatchBuilder)this.transform(new DivertRedirectorTransform(patcher));
        }

        @Override
        public Patch.ClassPatchBuilder disable() {
            return (Patch.ClassPatchBuilder)this.transform(DisableMixin.INSTANCE);
        }

        @Override
        public PatchInstance build() {
            return new ClassPatchInstance(List.copyOf(this.targetClasses), List.copyOf(this.targetMethods), List.copyOf(this.targetInjectionPoints), List.copyOf(this.targetAnnotations), this.targetAnnotationValues, List.copyOf(this.classTransforms), List.copyOf(this.transforms));
        }
    }
}

