/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.TxResult;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.pipeline.resolver.Resolver;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class TargetMethodResolver
implements Resolver {
    @Override
    public TxResult resolve(MixinData mixin, MixinContext context, Configuration clean, MutableConfiguration dirty, Recipe recipe) {
        if (dirty.getTargetMethod() != null) {
            return TxResult.PASS;
        }
        MethodQualifier cleanQualifier = clean.getTargetMethod();
        MethodContext.TargetPair target = context.methods().findOwnMethodPair(context.dirtyLookup(), cleanQualifier);
        if (target != null && !context.methods().findInjectionTargetInsns(target).isEmpty()) {
            dirty.inheritTargetMethod();
            return TxResult.SUCCESS;
        }
        if (this.handleChangedMethodParams(context, cleanQualifier, dirty)) {
            return TxResult.SUCCESS;
        }
        return TxResult.FAIL;
    }

    public boolean handleChangedMethodParams(MixinContext context, MethodQualifier cleanQualifier, MutableConfiguration dirty) {
        Pair<ClassNode, List<MethodNode>> candidates = context.methods().findOwnMethodsByName(context.dirtyLookup(), cleanQualifier);
        if (candidates == null) {
            return false;
        }
        MethodNode resolved = this.resolveReplacementCandidate(context, (ClassNode)candidates.getFirst(), (List)candidates.getSecond());
        if (resolved == null) {
            return false;
        }
        MethodContext.TargetPair cleanTarget = context.methods().findOwnMethodPair(context.cleanLookup(), cleanQualifier);
        if (!resolved.desc.equals(cleanTarget.methodNode().desc)) {
            dirty.setTargetMethod(resolved);
            return true;
        }
        return false;
    }

    @Nullable
    private MethodNode resolveReplacementCandidate(MixinContext context, ClassNode classNode, List<MethodNode> methods) {
        if (methods.size() == 1) {
            return methods.getFirst();
        }
        ArrayList<MethodNode> valid = new ArrayList<MethodNode>();
        for (MethodNode method : methods) {
            if (context.methods().findInjectionTargetInsns(new MethodContext.TargetPair(classNode, method)).isEmpty()) continue;
            valid.add(method);
        }
        return valid.size() == 1 ? (MethodNode)valid.getFirst() : null;
    }
}

