/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.events;

import com.pedrorok.hypertube.config.ServerConfig;
import com.pedrorok.hypertube.core.placement.TubePlacement;
import com.pedrorok.hypertube.core.travel.TravelConstants;
import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.utils.TubeUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="create_hypertube")
public class ModServerEvents {
    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        ServerConfig.get().init();
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!TravelConstants.TRAVELLER_ENTITIES.contains(living.getType())) {
            return;
        }
        TravelManager.entityTick(living);
        if (event.getEntity().level().isClientSide) {
            return;
        }
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        TubePlacement.tickPlayerServer(player);
    }

    @SubscribeEvent
    public static void entityHitBoxChangesWhenInHypertube(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (!entity.isAddedToLevel()) {
            return;
        }
        if (!TravelManager.hasHyperTubeData(entity)) {
            return;
        }
        event.setNewSize(EntityDimensions.fixed((float)0.5f, (float)0.5f));
        if (entity.level().isClientSide) {
            return;
        }
        entity.setPose(Pose.CROUCHING);
    }

    @SubscribeEvent
    public static void playerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (TravelManager.hasHyperTubeData(event.getEntity())) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (TubeUtils.checkPlayerPlacingBlock(player, (Level)event.getLevel(), event.getPos())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void playerBreakBlock(BlockEvent.BreakEvent event) {
        if (!TravelManager.hasHyperTubeData((Entity)event.getPlayer())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent.Pre event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (TravelManager.hasHyperTubeData((Entity)entity)) {
            event.setNewDamage(0.0f);
            entity.hurtMarked = false;
            return;
        }
        if (!entity.getPersistentData().getBoolean("hypertube_immunity")) {
            return;
        }
        entity.getPersistentData().putBoolean("hypertube_immunity", false);
        if (entity.getPersistentData().getLong("last_travel_time") < System.currentTimeMillis()) {
            return;
        }
        event.getContainer().setNewDamage(0.0f);
        entity.hurtMarked = true;
    }
}

